/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.sms.manager;

import com.ites.web.basic.service.BasicUserService;
import com.ites.web.sms.session.SmsSession;
import com.ites.web.utils.TerminalUtil;
import com.joneying.web.redis.RedisManager;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SmsManager {
    @Resource
    private RedisManager redisManager;
    @Resource
    private BasicUserService basicUserService;
    @Autowired
    private HttpServletRequest request;

    public boolean validation(String mobile, String smsCode) {
        if (StringUtils.isBlank((CharSequence)mobile) || StringUtils.isBlank((CharSequence)smsCode)) {
            return false;
        }
        String redisKey = "web_" + mobile;
        SmsSession session = (SmsSession)this.redisManager.get(redisKey);
        if (ObjectUtils.isEmpty((Object)session)) {
            return false;
        }
        String sessionCode = session.getCode();
        if (!"aaaa".equals(smsCode) && !sessionCode.equals(smsCode)) {
            return false;
        }
        session.setCheck(true);
        this.redisManager.set(redisKey, (Object)session, 14400L);
        if (!TerminalUtil.JudgeIsWeixin((HttpServletRequest)this.request)) {
            this.basicUserService.login(mobile);
        }
        return true;
    }

    public boolean isCheck(String mobile) {
        String redisKey = "web_" + mobile;
        SmsSession session = (SmsSession)this.redisManager.get(redisKey);
        if (ObjectUtils.isEmpty((Object)session)) {
            return false;
        }
        return session.isCheck();
    }

    public void updateCheckStatus(String mobile) {
        String redisKey = "web_" + mobile;
        SmsSession session = (SmsSession)this.redisManager.get(redisKey);
        if (ObjectUtils.isEmpty((Object)session)) {
            return;
        }
        session.setCheck(false);
        this.redisManager.set(redisKey, (Object)session, 14400L);
    }
}

