/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.utils;

import com.ites.web.utils.OssUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final String EXTENSION_XLS = "xls";
    private static final String EXTENSION_XLSX = "xlsx";

    public static Workbook getWorkbook(MultipartFile file) throws IOException {
        HSSFWorkbook workbook = null;
        String fileName = file.getOriginalFilename();
        InputStream is = file.getInputStream();
        if (fileName.endsWith(EXTENSION_XLS)) {
            workbook = new HSSFWorkbook(is);
        } else if (fileName.endsWith(EXTENSION_XLSX)) {
            workbook = new XSSFWorkbook(is);
        }
        return workbook;
    }

    public static boolean isRowEmpty(Row row) {
        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
            Cell cell = row.getCell(c);
            if (cell == null || cell.getCellType() == 3) continue;
            return false;
        }
        return true;
    }

    public static String getStringCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        String strCell = "";
        switch (cell.getCellType()) {
            case 1: {
                strCell = cell.getStringCellValue();
                break;
            }
            case 0: {
                String value;
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = cell.getDateCellValue();
                    strCell = sdf.format(date);
                    break;
                }
                DecimalFormat df = new DecimalFormat("#0.00");
                strCell = value = df.format(cell.getNumericCellValue());
                break;
            }
            case 4: {
                strCell = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 3: {
                strCell = "";
                break;
            }
            default: {
                strCell = "";
            }
        }
        if (strCell.equals("") || strCell == null) {
            return "";
        }
        return strCell;
    }

    public static String exportExcel(List<Map<String, String>> titleList, List<List<?>> CONTENT_LISTS, String SEQ_TITLE, int SEQ_INDEX, int SEQ_START_INDEX, int SEQ_STEP_LENGTH, List<String> SHEET_NAMES, String filePath) throws Exception {
        if (null == CONTENT_LISTS || CONTENT_LISTS.size() < 1) {
            return null;
        }
        HSSFWorkbook hssfWorkBook = new HSSFWorkbook();
        String SHEET_NAME = "";
        for (int s = 0; s < CONTENT_LISTS.size(); ++s) {
            HSSFSheet sheet = hssfWorkBook.createSheet();
            SHEET_NAME = SHEET_NAMES.get(s);
            if (StringUtils.isBlank((String)SHEET_NAME)) {
                SHEET_NAME = "\u7b2c\u4e00\u9875";
            }
            hssfWorkBook.setSheetName(s, SHEET_NAME);
            int TITLE_LIST_SIZE = titleList.get(s).size();
            int COLUMN_COUNT = SEQ_INDEX >= 0 ? TITLE_LIST_SIZE + 1 : TITLE_LIST_SIZE;
            int COLUMN_WIDTH = 5632;
            int index = 0;
            for (int j = 0; j < COLUMN_COUNT; ++j) {
                sheet.setColumnWidth((short)index++, (short)5632);
            }
            int FIRST_ROW_BACKGROUND_COLOR_INDEX = 9;
            int FIRST_ROW_BORDER_COLOR_INDEX = 10;
            int OTHER_ROW_BACKGROUND_COLOR_INDEX = 11;
            int OTHER_ROW_BORDER_COLOR_INDEX = 12;
            HSSFPalette palette = hssfWorkBook.getCustomPalette();
            palette.setColorAtIndex((short)9, (byte)-26, (byte)-11, (byte)-18);
            palette.setColorAtIndex((short)10, (byte)0, (byte)-103, (byte)102);
            palette.setColorAtIndex((short)11, (byte)-1, (byte)-1, (byte)-1);
            palette.setColorAtIndex((short)12, (byte)-103, (byte)-103, (byte)-103);
            int sequence = SEQ_START_INDEX;
            int j = CONTENT_LISTS.get(s).size();
            for (int i = 0; i < j + 1; ++i) {
                HSSFRow row = sheet.createRow(i);
                int colIndex = 0;
                ArrayList<HSSFCell> cellList = new ArrayList<HSSFCell>();
                HSSFCellStyle cellStyle = hssfWorkBook.createCellStyle();
                cellStyle.setWrapText(true);
                cellStyle.setAlignment((short)2);
                cellStyle.setVerticalAlignment((short)1);
                cellStyle.setFillPattern((short)1);
                for (int k = 0; k < COLUMN_COUNT; ++k) {
                    HSSFCell cell = row.createCell((short)colIndex++);
                    cell.setCellStyle(cellStyle);
                    cellList.add(cell);
                    cellStyle.setBorderTop((short)1);
                    cellStyle.setBorderLeft((short)1);
                    cellStyle.setBorderRight((short)1);
                    cellStyle.setBorderBottom((short)1);
                    cellStyle.setTopBorderColor((short)12);
                    cellStyle.setLeftBorderColor((short)12);
                    cellStyle.setRightBorderColor((short)12);
                    cellStyle.setBottomBorderColor((short)12);
                    cellStyle.setFillForegroundColor((short)11);
                }
                if (0 == i) {
                    row.setHeight((short)600);
                    cellStyle.setFillForegroundColor((short)9);
                    cellStyle.setTopBorderColor((short)10);
                    cellStyle.setLeftBorderColor((short)10);
                    cellStyle.setRightBorderColor((short)10);
                    cellStyle.setBottomBorderColor((short)10);
                    Set<String> titlePropertySet = titleList.get(s).keySet();
                    Iterator<String> itTitleProperty = titlePropertySet.iterator();
                    for (int k = 0; k < COLUMN_COUNT; ++k) {
                        if (SEQ_INDEX == k) {
                            ((HSSFCell)cellList.get(k)).setCellValue(SEQ_TITLE);
                        } else if (itTitleProperty.hasNext()) {
                            ((HSSFCell)cellList.get(k)).setCellValue(titleList.get(s).get(itTitleProperty.next()));
                        }
                        ((HSSFCell)cellList.get(k)).setCellStyle(cellStyle);
                    }
                    continue;
                }
                Object dto = CONTENT_LISTS.get(s).get(i - 1);
                Set<String> titlePropertySet = titleList.get(s).keySet();
                Iterator<String> itTitleProperty = titlePropertySet.iterator();
                for (int k = 0; k < COLUMN_COUNT; ++k) {
                    if (SEQ_INDEX == k) {
                        ((HSSFCell)cellList.get(k)).setCellValue((double)sequence);
                        sequence += SEQ_STEP_LENGTH;
                        continue;
                    }
                    if (!itTitleProperty.hasNext()) continue;
                    String key = itTitleProperty.next();
                    Object obj = dto.getClass().getMethod("get" + key, new Class[0]).invoke(dto, new Object[0]);
                    if (obj instanceof Number) {
                        ((HSSFCell)cellList.get(k)).setCellValue(((Number)obj).doubleValue());
                        continue;
                    }
                    if (obj instanceof Date) {
                        ((HSSFCell)cellList.get(k)).setCellValue(new SimpleDateFormat("yyyy-MM-dd HH:mm").format((Date)obj));
                        continue;
                    }
                    if (obj instanceof ArrayList) {
                        List item = (List)obj;
                        StringBuffer registNoBuffer = new StringBuffer("");
                        for (String str : item) {
                            registNoBuffer.append(str + "\r\n");
                        }
                        ((HSSFCell)cellList.get(k)).setCellValue(registNoBuffer.toString());
                        continue;
                    }
                    if (null == obj) {
                        ((HSSFCell)cellList.get(k)).setCellValue(" ");
                        continue;
                    }
                    ((HSSFCell)cellList.get(k)).setCellValue(obj.toString());
                }
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        hssfWorkBook.write((OutputStream)os);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
        String url = OssUtil.uploadObject((InputStream)byteArrayInputStream, (String)filePath);
        os.flush();
        os.close();
        return url;
    }
}

