/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.utils;

import com.ites.web.captcha.dto.ImageVerificationDto;
import com.ites.web.captcha.exception.ServiceException;
import com.ites.web.captcha.exception.ServiceExceptionCode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImageVerificationUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageVerificationUtil.class);
    private static final int DEFAULT_IMAGE_WIDTH = 280;
    private static final int DEFAULT_IMAGE_HEIGHT = 171;

    protected static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    protected static HttpServletResponse getResponse() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }

    public static ImageVerificationDto generateCutoutCoordinates(BufferedImage verificationImage, BufferedImage templateImage) {
        int templateImageWidth = templateImage.getWidth();
        int templateImageHeight = templateImage.getHeight();
        Random random = new Random(System.currentTimeMillis());
        int x = random.nextInt(280 - templateImageWidth) % (280 - templateImageWidth - templateImageWidth + 1) + templateImageWidth;
        int y = random.nextInt(171 - templateImageWidth) % (171 - templateImageWidth - templateImageWidth + 1) + templateImageWidth;
        if (templateImageHeight - 171 >= 0) {
            y = random.nextInt(10);
        }
        ImageVerificationDto imageVerificationDto = new ImageVerificationDto();
        imageVerificationDto.setX(x);
        imageVerificationDto.setY(y);
        return imageVerificationDto;
    }

    public static ImageVerificationDto pictureTemplateCutout(File originImageFile, String originImageFileType, File templateImageFile, String templateImageFileType, int x, int y) throws ServiceException {
        ImageVerificationDto imageVerificationDto = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            BufferedImage templateImage = ImageIO.read(templateImageFile);
            BufferedImage originImage = ImageIO.read(originImageFile);
            int templateImageWidth = templateImage.getWidth();
            int templateImageHeight = templateImage.getHeight();
            BufferedImage cutoutImage = new BufferedImage(templateImageWidth, templateImageHeight, templateImage.getType());
            BufferedImage interestArea = ImageVerificationUtil.getInterestArea((int)x, (int)y, (int)templateImageWidth, (int)templateImageHeight, (File)originImageFile, (String)originImageFileType);
            cutoutImage = ImageVerificationUtil.cutoutImageByTemplateImage((BufferedImage)interestArea, (BufferedImage)templateImage, (BufferedImage)cutoutImage);
            int bold = 5;
            Graphics2D graphics = cutoutImage.createGraphics();
            graphics.setBackground(Color.white);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setStroke(new BasicStroke(bold, 0, 2));
            graphics.drawImage((Image)cutoutImage, 0, 0, null);
            graphics.dispose();
            BufferedImage shadeImage = ImageVerificationUtil.generateShadeByTemplateImage((BufferedImage)originImage, (BufferedImage)templateImage, (int)x, (int)y);
            imageVerificationDto = new ImageVerificationDto();
            byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)originImage, originImageFileType, byteArrayOutputStream);
            byte[] originImageBytes = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.reset();
            String originImageString = Base64Utils.encodeToString((byte[])originImageBytes);
            imageVerificationDto.setOriginImage(originImageString);
            ImageIO.write((RenderedImage)shadeImage, templateImageFileType, byteArrayOutputStream);
            byte[] shadeImageBytes = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.reset();
            String shadeImageString = Base64Utils.encodeToString((byte[])shadeImageBytes);
            imageVerificationDto.setShadeImage(shadeImageString);
            ImageIO.write((RenderedImage)cutoutImage, templateImageFileType, byteArrayOutputStream);
            byte[] cutoutImageBytes = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            String cutoutImageString = Base64Utils.encodeToString((byte[])cutoutImageBytes);
            imageVerificationDto.setCutoutImage(cutoutImageString);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(ServiceExceptionCode.IO_EXCEPTION);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ServiceException(ServiceExceptionCode.IO_EXCEPTION);
            }
        }
        return imageVerificationDto;
    }

    private static BufferedImage generateShadeByTemplateImage(BufferedImage originImage, BufferedImage templateImage, int x, int y) throws IOException {
        int rgb;
        int j;
        int i;
        BufferedImage shadeImage = new BufferedImage(originImage.getWidth(), originImage.getHeight(), 2);
        int[][] originImageMatrix = ImageVerificationUtil.getMatrix((BufferedImage)originImage);
        int[][] templateImageMatrix = ImageVerificationUtil.getMatrix((BufferedImage)templateImage);
        for (i = 0; i < originImageMatrix.length; ++i) {
            for (j = 0; j < originImageMatrix[0].length; ++j) {
                rgb = originImage.getRGB(i, j);
                int r = 0xFF & rgb;
                int g = 0xFF & rgb >> 8;
                int b = 0xFF & rgb >> 16;
                rgb = r + (g << 8) + (b << 16) + -16777216;
                shadeImage.setRGB(i, j, rgb);
            }
        }
        for (i = 0; i < templateImageMatrix.length; ++i) {
            for (j = 0; j < templateImageMatrix[0].length; ++j) {
                rgb = templateImage.getRGB(i, j);
                if (rgb == 0xFFFFFF || rgb >= 0) continue;
                int originRGB = shadeImage.getRGB(x + i, y + j);
                int r = 0 & originRGB;
                int g = 0 & originRGB >> 8;
                int b = 0 & originRGB >> 16;
                originRGB = r + (g << 8) + (b << 16) + -1946157056;
                shadeImage.setRGB(x + i, y + j, originRGB);
            }
        }
        return shadeImage;
    }

    private static BufferedImage cutoutImageByTemplateImage(BufferedImage interestArea, BufferedImage templateImage, BufferedImage cutoutImage) {
        int[][] interestAreaMatrix = ImageVerificationUtil.getMatrix((BufferedImage)interestArea);
        int[][] templateImageMatrix = ImageVerificationUtil.getMatrix((BufferedImage)templateImage);
        for (int i = 0; i < templateImageMatrix.length; ++i) {
            for (int j = 0; j < templateImageMatrix[0].length; ++j) {
                int rgb = templateImageMatrix[i][j];
                if (rgb == 0xFFFFFF || rgb >= 0) continue;
                cutoutImage.setRGB(i, j, interestArea.getRGB(i, j));
            }
        }
        return cutoutImage;
    }

    private static int[][] getMatrix(BufferedImage bufferedImage) {
        int[][] matrix = new int[bufferedImage.getWidth()][bufferedImage.getHeight()];
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                matrix[i][j] = bufferedImage.getRGB(i, j);
            }
        }
        return matrix;
    }

    private static BufferedImage getInterestArea(int x, int y, int templateImageWidth, int templateImageHeight, File originImage, String originImageType) throws ServiceException {
        ImageInputStream imageInputStream = null;
        try {
            BufferedImage interestImage;
            Iterator<ImageReader> imageReaderIterator = ImageIO.getImageReadersByFormatName(originImageType);
            ImageReader imageReader = imageReaderIterator.next();
            imageInputStream = ImageIO.createImageInputStream(originImage);
            imageReader.setInput(imageInputStream, true);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            Rectangle rectangle = new Rectangle(x, y, templateImageWidth, templateImageHeight);
            imageReadParam.setSourceRegion(rectangle);
            BufferedImage bufferedImage = interestImage = imageReader.read(0, imageReadParam);
            return bufferedImage;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(ServiceExceptionCode.IO_EXCEPTION);
        }
        finally {
            try {
                imageInputStream.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ServiceException(ServiceExceptionCode.IO_EXCEPTION);
            }
        }
    }

    public static ImageVerificationDto cutoutImageEdge(ImageVerificationDto imageVerificationDto, BufferedImage borderImage, String borderImageFileType) throws ServiceException {
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            String cutoutImageString = imageVerificationDto.getCutoutImage();
            byte[] bytes = Base64Utils.decodeFromString((String)cutoutImageString);
            byteArrayInputStream = new ByteArrayInputStream(bytes);
            BufferedImage cutoutImage = ImageIO.read(byteArrayInputStream);
            int[][] borderImageMatrix = ImageVerificationUtil.getMatrix((BufferedImage)borderImage);
            for (int i = 0; i < borderImageMatrix.length; ++i) {
                for (int j = 0; j < borderImageMatrix[0].length; ++j) {
                    int rgb = borderImage.getRGB(i, j);
                    if (rgb >= 0) continue;
                    cutoutImage.setRGB(i, j, -7237488);
                }
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)cutoutImage, borderImageFileType, byteArrayOutputStream);
            byte[] cutoutImageBytes = byteArrayOutputStream.toByteArray();
            String cutoutImageStr = Base64Utils.encodeToString((byte[])cutoutImageBytes);
            imageVerificationDto.setCutoutImage(cutoutImageStr);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(ServiceExceptionCode.IO_EXCEPTION);
        }
        finally {
            try {
                byteArrayInputStream.close();
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ServiceException(ServiceExceptionCode.IO_EXCEPTION);
            }
        }
        return imageVerificationDto;
    }
}

