/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);
    private static final long expire = 604800000L;
    private static final String secret = "web-api";

    public static String generateToken(long userId) {
        Date nowDate = new Date();
        Date expireDate = new Date(nowDate.getTime() + 604800000000L);
        return Jwts.builder().setHeaderParam("typ", (Object)"JWT").setSubject(userId + "").setIssuedAt(nowDate).setExpiration(expireDate).signWith(SignatureAlgorithm.HS512, secret).compact();
    }

    public static Claims getClaimByToken(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            log.debug("validate is token error ", (Throwable)e);
            return null;
        }
    }

    public static boolean isTokenExpired(Date expiration) {
        return expiration.before(new Date());
    }
}

