/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.ites.web.utils.OssUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.springframework.core.io.ClassPathResource;

public class QrcodeUtil {
    private static final int QRCOLOR = -16777216;
    private static final int BGWHITE = -1;
    private static Map<EncodeHintType, Object> hints = new /* Unavailable Anonymous Inner Class!! */;

    public static String createQRCode(String content, int WIDTH, int HEIGHT, String language) {
        try {
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            BitMatrix bm = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, WIDTH, HEIGHT, hints);
            BufferedImage image = new BufferedImage(WIDTH, HEIGHT, 1);
            for (int x = 0; x < WIDTH; ++x) {
                for (int y = 0; y < HEIGHT; ++y) {
                    image.setRGB(x, y, bm.get(x, y) ? -16777216 : -1);
                }
            }
            int width = image.getWidth();
            int height = image.getHeight();
            ClassPathResource resource = new ClassPathResource("static/logo/ITES.png");
            InputStream inputStream = resource.getInputStream();
            Graphics2D g = image.createGraphics();
            BufferedImage logo = ImageIO.read(inputStream);
            g.drawImage(logo, width * 2 / 5, height * 2 / 5, width * 2 / 10, height * 2 / 10, null);
            g.dispose();
            logo.flush();
            image.flush();
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
            ImageIO.write((RenderedImage)image, "png", imOut);
            ByteArrayInputStream is = new ByteArrayInputStream(bs.toByteArray());
            return OssUtil.uploadObject((InputStream)is, (String)("web/" + language + "/qr/2021/" + content + ".png"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String createPayQRCode(String content, String outTradeNo, int WIDTH, int HEIGHT, String language) {
        try {
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            BitMatrix bm = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, WIDTH, HEIGHT, hints);
            BufferedImage image = new BufferedImage(WIDTH, HEIGHT, 1);
            for (int x = 0; x < WIDTH; ++x) {
                for (int y = 0; y < HEIGHT; ++y) {
                    image.setRGB(x, y, bm.get(x, y) ? -16777216 : -1);
                }
            }
            int width = image.getWidth();
            int height = image.getHeight();
            ClassPathResource resource = new ClassPathResource("static/logo/ITES.png");
            InputStream inputStream = resource.getInputStream();
            Graphics2D g = image.createGraphics();
            BufferedImage logo = ImageIO.read(inputStream);
            g.drawImage(logo, width * 2 / 5, height * 2 / 5, width * 2 / 10, height * 2 / 10, null);
            g.dispose();
            logo.flush();
            image.flush();
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
            ImageIO.write((RenderedImage)image, "png", imOut);
            ByteArrayInputStream is = new ByteArrayInputStream(bs.toByteArray());
            return OssUtil.uploadObject((InputStream)is, (String)("web/" + language + "/qr/2021/" + outTradeNo + ".png"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

