/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.controller;

import com.google.common.collect.Lists;
import com.ites.web.utils.http.HttpUtil;
import com.ites.web.visit.entity.VisitRegistInfo;
import com.ites.web.visit.service.VisitRegistInfoService;
import com.joneying.web.redis.RedisManager;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.external.WxCpContactWayInfo;
import me.chanjar.weixin.cp.bean.external.WxCpContactWayResult;
import net.sf.json.JSONObject;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f01\u4e1a\u5fae\u4fe1"})
@RequestMapping(value={"/company/we/chat"})
public class CompanyWeChatController {
    @Resource
    private WxCpService wxCpService;
    @Resource
    private VisitRegistInfoService visitRegistInfoService;
    @Resource
    private RedisManager redisManager;

    @GetMapping(value={"/qrCode"})
    @ApiOperation(value="\u751f\u6210\u4e8c\u7ef4\u7801")
    public Result<String> qrCode(@RequestParam String phone) throws WxErrorException {
        String defaultUser = "YeXinYi01";
        String defaultSourceKey = "2023ydjgytjqw";
        String key = "addContact:Qrcode:" + phone + ":" + "YeXinYi01";
        Object o = this.redisManager.get(key);
        if (Objects.nonNull(o)) {
            return R.ok((Object)o.toString());
        }
        WxCpContactWayInfo wxCpContactWayInfo = new WxCpContactWayInfo();
        WxCpContactWayInfo.ContactWay contactWay = new WxCpContactWayInfo.ContactWay();
        contactWay.setType(WxCpContactWayInfo.TYPE.SINGLE);
        contactWay.setScene(WxCpContactWayInfo.SCENE.QRCODE);
        contactWay.setState(phone + ":" + ":" + "2023ydjgytjqw");
        contactWay.setUsers((List)Lists.newArrayList((Object[])new String[]{"YeXinYi01"}));
        wxCpContactWayInfo.setContactWay(contactWay);
        WxCpContactWayResult wxCpContactWayResult = this.wxCpService.getExternalContactService().addContactWay(wxCpContactWayInfo);
        this.redisManager.set(key, (Object)wxCpContactWayResult.getQrCode(), 7L, TimeUnit.DAYS);
        return R.ok((Object)wxCpContactWayResult.getQrCode());
    }

    @GetMapping(value={"/queryAddCompanyWeChat"})
    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u7ed1\u5b9a\u4f01\u4e1a\u5fae\u4fe1")
    public Result<Boolean> queryAddCompanyWeChat(@RequestParam String phone) {
        VisitRegistInfo visitRegistInfo = this.visitRegistInfoService.findByMobile(phone);
        if (visitRegistInfo.getIsBindCompanyWechat().booleanValue()) {
            return R.ok((Object)visitRegistInfo.getIsBindCompanyWechat());
        }
        String url = "http://hive-api.iteschina.com/we/contact/way/queryIsAdd?phone=" + phone;
        String result = HttpUtil.get((String)url);
        JSONObject object = JSONObject.fromObject((Object)result);
        boolean data = object.getBoolean("data");
        if (data) {
            visitRegistInfo.setIsBindCompanyWechat(Boolean.valueOf(true));
            this.visitRegistInfoService.updateById((Object)visitRegistInfo);
            this.visitRegistInfoService.sendMailAndMessage(visitRegistInfo);
        }
        return R.ok((Object)data);
    }
}

