/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.controller;

import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.visit.entity.VisitRegistInfo;
import com.ites.web.visit.entity.WebRedeemCode;
import com.ites.web.visit.service.VisitRegistInfoService;
import com.ites.web.visit.service.WebRedeemCodeService;
import com.ites.web.visit.vo.WebRedeemCodeVO;
import com.joneying.web.authentication.annotation.ExculdeLogin;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5151\u6362\u7801\u8868 API"})
public class WebRedeemCodeController
extends BaseController {
    @Resource
    private WebRedeemCodeService webRedeemCodeService;
    @Resource
    private VisitRegistInfoService visitRegistInfoService;

    @ExculdeLogin
    @GetMapping
    @ApiOperation(value="\u751f\u6210\u5151\u6362\u7801", httpMethod="GET")
    public Result generate() {
        return R.ok((Object)this.webRedeemCodeService.generator());
    }

    @GetMapping
    @ApiOperation(value="\u6838\u9500\u5151\u6362\u7801", httpMethod="GET")
    public Result<WebRedeemCodeVO> verification(@PathVariable(value="id") Integer id, @PathVariable(value="code") String code) {
        WebRedeemCode webRedeemCode = this.webRedeemCodeService.findByCode(code);
        if (ObjectUtils.isEmpty((Object)webRedeemCode)) {
            return R.failure((String)"5106");
        }
        this.webRedeemCodeService.removeById((Serializable)webRedeemCode.getId());
        VisitRegistInfo visitRegistInfo = (VisitRegistInfo)this.visitRegistInfoService.getById((Serializable)id);
        visitRegistInfo.setRedeemCode(webRedeemCode.getCode());
        visitRegistInfo.setOrderStatus(WebConstant.WX_PAID);
        EntityDateUtil.supplementUpdate((BaseEntity)visitRegistInfo);
        this.visitRegistInfoService.updateById((Object)visitRegistInfo);
        this.visitRegistInfoService.sendMailAndMessage(visitRegistInfo);
        return R.ok();
    }
}

