/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.valid.interfaces.Insert;
import com.ites.web.common.valid.interfaces.Update;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.sms.manager.SmsManager;
import com.ites.web.visit.entity.WebVisitGroup;
import com.ites.web.visit.entity.WebVisitGroupUser;
import com.ites.web.visit.service.VisitRegistNoService;
import com.ites.web.visit.service.WebVisitGroupService;
import com.ites.web.visit.service.WebVisitGroupUserService;
import com.ites.web.visit.vo.VisitGroupUserVO;
import com.ites.web.visit.vo.WebVisitGroupUserVO;
import com.ites.web.visit.vo.WebVisitGroupVO;
import com.joneying.web.authentication.annotation.ExculdeLogin;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.logger.annotation.CommonController;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import com.simm.publicservice.export.IdentityCardServiceExport;
import com.simm.publicservice.export.SmsServiceExport;
import com.simm.publicservice.pojo.Resp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56e2\u4f53\u767b\u8bb0 API"})
public class WebVisitGroupController
extends BaseController {
    @Resource
    private WebVisitGroupService webVisitGroupService;
    @Resource
    private WebVisitGroupUserService webVisitGroupUserService;
    @Resource
    private VisitRegistNoService visitRegistNoService;
    @Resource
    private SmsManager smsManager;
    @Reference
    private SmsServiceExport smsServiceExport;
    @Reference
    private IdentityCardServiceExport identityCardServiceExport;

    @ExculdeLogin
    @GetMapping
    @CommonController(description="\u6839\u636e\u624b\u673a\u53f7\u7801\u67e5\u8be2\u662f\u5426\u4e3a\u56e2\u4f53\u767b\u8bb0\u89c2\u4f17")
    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u7801\u67e5\u8be2\u662f\u5426\u4e3a\u56e2\u4f53\u767b\u8bb0\u89c2\u4f17", httpMethod="GET")
    public Result findByMobile(@PathVariable(value="mobile") String mobile, @PathVariable(value="code") String code) {
        boolean validation = this.smsManager.validation(mobile, code);
        if (!validation) {
            return R.failure();
        }
        WebVisitGroupUser groupUser = this.webVisitGroupUserService.findByMobile(mobile);
        if (ObjectUtils.isEmpty((Object)groupUser)) {
            return R.ok();
        }
        Integer groupId = groupUser.getGroupId();
        WebVisitGroup webVisitGroup = (WebVisitGroup)this.webVisitGroupService.getById((Serializable)groupId);
        WebVisitGroupVO webVisitGroupVO = (WebVisitGroupVO)BaseVO.conversion((BaseEntity)webVisitGroup, WebVisitGroupVO.class);
        List groupUsers = this.webVisitGroupUserService.findByGroupId(groupId);
        List groupUserVos = BaseVO.conversion((List)groupUsers, WebVisitGroupUserVO.class);
        VisitGroupUserVO vo = new VisitGroupUserVO();
        vo.setWebVisitGroupVO(webVisitGroupVO);
        vo.setUserVos(groupUserVos);
        return R.ok((Object)vo);
    }

    @ExculdeLogin
    @PostMapping
    @CommonController(description="\u65b0\u589e\u56e2\u4f53\u89c2\u4f17\u4fe1\u606f")
    @ApiOperation(value="\u65b0\u589e\u56e2\u4f53\u89c2\u4f17\u4fe1\u606f", httpMethod="POST")
    public Result saveGroupUser(@RequestBody @Validated(value={Insert.class}) WebVisitGroupUser webVisitGroupUser) {
        Resp resp = this.identityCardServiceExport.identityCard(webVisitGroupUser.getIdentityCard(), webVisitGroupUser.getName());
        if (!"200".equals(resp.getCode())) {
            return R.failure((String)"5105", (String)resp.getMessage());
        }
        if (webVisitGroupUser.getMaster().booleanValue()) {
            WebVisitGroup group = this.webVisitGroupService.findByName(webVisitGroupUser.getCompany());
            if (ObjectUtils.isNotEmpty((Object)group)) {
                return R.failure((String)"5201");
            }
            WebVisitGroupUser groupUser = this.webVisitGroupUserService.findByMobile(webVisitGroupUser.getMobile());
            if (ObjectUtils.isNotEmpty((Object)groupUser)) {
                return R.failure((String)"5202");
            }
            Integer groupId = this.webVisitGroupUserService.addUserAndGroup(webVisitGroupUser);
            String content = "\u5c0a\u656c\u7684" + webVisitGroupUser.getName() + "\uff0c\u60a8\u5df2\u6210\u529f\u767b\u8bb0\u53c2" + "2023" + " ITES\u6df1\u5733\u5de5\u4e1a\u5c55\u56e2\u4f53\u89c2\u4f17\u300210\u4eba\u4ee5\u4e0a\u56e2\u4f53\u53ef\u83b7\u5c55\u524d\u514d\u8d39\u90ae\u5bc4\u53c2\u89c2\u8bc1\u670d\u52a1\u30023\u670829\u65e5-4\u67081\u65e5\uff0c\u6df1\u5733\u56fd\u9645\u4f1a\u5c55\u4e2d\u5fc3\uff08\u5b9d\u5b89\u65b0\u9986\uff09\uff0c\u671f\u5f85\u60a8\u7684\u8385\u4e34\u3002\u6dfb\u52a0\u540c\u884c\u4eba\uff1ahttps://www.iteschina.com/zh-cn/audience/register/group-info\u3010ITES\u6df1\u5733\u5de5\u4e1a\u5c55\u3011";
            this.smsServiceExport.sendCode(webVisitGroupUser.getMobile(), content);
            return R.ok((Object)groupId);
        }
        if (webVisitGroupUser.getGroupId() == null) {
            return R.failure((String)"5203");
        }
        WebVisitGroupUser groupUser = this.webVisitGroupUserService.findByMobile(webVisitGroupUser.getMobile());
        if (ObjectUtils.isNotEmpty((Object)groupUser)) {
            return R.failure((String)"5202");
        }
        webVisitGroupUser.setNumber(WebConstant.NUMBER);
        String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN_TEAM);
        webVisitGroupUser.setCardNo(cardNo);
        this.webVisitGroupUserService.save((Object)webVisitGroupUser);
        return R.ok((Object)webVisitGroupUser.getGroupId());
    }

    @PostMapping
    @CommonController(description="\u6839\u636e\u56e2\u4f53id\u7ed9\u6307\u5b9a\u56e2\u4f53\u6dfb\u52a0\u8f66\u724c\u53f7")
    @ApiOperation(value="\u6839\u636e\u56e2\u4f53id\u7ed9\u6307\u5b9a\u56e2\u4f53\u6dfb\u52a0\u8f66\u724c\u53f7", httpMethod="POST")
    public Result addCarNos(@RequestBody WebVisitGroup params) {
        if (Objects.isNull(params.getId())) {
            return R.failure((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WebVisitGroup visitGroup = (WebVisitGroup)this.webVisitGroupService.getById((Serializable)params.getId());
        visitGroup.setCarNos(params.getCarNos());
        boolean update = this.webVisitGroupService.updateById((Object)visitGroup);
        return update ? R.ok() : R.failure();
    }

    @GetMapping
    @CommonController(description="\u6839\u636e\u56e2\u4f53id\u83b7\u53d6\u56e2\u4f53\u4fe1\u606f")
    @ApiOperation(value="\u6839\u636e\u56e2\u4f53id\u83b7\u53d6\u56e2\u4f53\u4fe1\u606f", httpMethod="GET")
    public Result findByGroupId(@PathVariable(value="groupId") Integer groupId) {
        VisitGroupUserVO vo = new VisitGroupUserVO();
        WebVisitGroup webVisitGroup = (WebVisitGroup)this.webVisitGroupService.getById((Serializable)groupId);
        WebVisitGroupVO webVisitGroupVO = (WebVisitGroupVO)BaseVO.conversion((BaseEntity)webVisitGroup, WebVisitGroupVO.class);
        List groupUsers = this.webVisitGroupUserService.findByGroupId(groupId);
        List groupUserVos = BaseVO.conversion((List)groupUsers, WebVisitGroupUserVO.class);
        vo.setWebVisitGroupVO(webVisitGroupVO);
        vo.setUserVos(groupUserVos);
        return R.ok((Object)vo);
    }

    @PostMapping
    @CommonController(description="\u4fee\u6539\u53c2\u89c2\u56e2\u4fe1\u606f")
    @ApiOperation(value="\u4fee\u6539\u53c2\u89c2\u56e2\u4fe1\u606f", httpMethod="POST")
    public Result updateGroup(@RequestBody @Validated(value={Update.class}) WebVisitGroup webVisitGroup) {
        this.webVisitGroupService.updateById((Object)webVisitGroup);
        return R.ok();
    }

    @PostMapping
    @CommonController(description="\u4fee\u6539\u53c2\u89c2\u56e2\u4eba\u5458\u4fe1\u606f")
    @ApiOperation(value="\u4fee\u6539\u53c2\u89c2\u56e2\u4eba\u5458\u4fe1\u606f", httpMethod="POST")
    public Result updateGroupUser(@RequestBody @Validated(value={Update.class}) WebVisitGroupUser webVisitGroupUser) {
        this.webVisitGroupUserService.updateById((Object)webVisitGroupUser);
        return R.ok();
    }

    @GetMapping
    @CommonController(description="\u5220\u9664\u53c2\u89c2\u56e2\u4eba\u5458\u4fe1\u606f")
    @ApiOperation(value="\u5220\u9664\u53c2\u89c2\u56e2\u4eba\u5458\u4fe1\u606f", httpMethod="GET")
    public Result deleteGroupUser(@PathVariable(value="id") Integer id) {
        this.webVisitGroupUserService.removeById((Serializable)id);
        return R.ok();
    }

    @GetMapping
    @CommonController(description="\u4fee\u6539\u4e3b\u8054\u7cfb\u4eba")
    @ApiOperation(value="\u4fee\u6539\u4e3b\u8054\u7cfb\u4eba", httpMethod="GET")
    public Result updateGroupUserMaster(@PathVariable(value="id") Integer id, @PathVariable(value="groupId") Integer groupId) {
        this.webVisitGroupUserService.updateGroupUserMaster(id, groupId);
        return R.ok();
    }

    @GetMapping
    @CommonController(description="\u540c\u6b65\u56e2\u4f53\u89c2\u4f17\u5230\u8702\u5de2")
    @ApiOperation(value="\u540c\u6b65\u56e2\u4f53\u89c2\u4f17\u5230\u8702\u5de2", httpMethod="GET")
    public List<WebVisitGroupUser> sync() {
        List list = this.webVisitGroupUserService.findWaitSync();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return list;
    }

    @GetMapping
    @CommonController(description="\u4fee\u6539\u56e2\u4f53\u6807\u8bc6")
    @ApiOperation(value="\u4fee\u6539\u56e2\u4f53\u6807\u8bc6", httpMethod="GET")
    public Result ack(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.webVisitGroupUserService.updateSync(ids);
        }
        return R.ok();
    }

    @GetMapping
    @CommonController(description="\u6839\u636eid\u83b7\u53d6\u503c")
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u503c", httpMethod="GET")
    public WebVisitGroup findById(@PathVariable(value="id") Integer id) {
        WebVisitGroup webVisitGroup = (WebVisitGroup)this.webVisitGroupService.getById((Serializable)id);
        return webVisitGroup;
    }
}

