/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.visit.dao.WebVisitGroupUserDao;
import com.ites.web.visit.entity.WebVisitGroup;
import com.ites.web.visit.entity.WebVisitGroupUser;
import com.ites.web.visit.service.VisitRegistNoService;
import com.ites.web.visit.service.WebVisitGroupService;
import com.ites.web.visit.service.WebVisitGroupUserService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="webVisitGroupUserService")
public class WebVisitGroupUserServiceImpl
extends ServiceImpl<WebVisitGroupUserDao, WebVisitGroupUser>
implements WebVisitGroupUserService {
    @Resource
    private WebVisitGroupService webVisitGroupService;
    @Resource
    private VisitRegistNoService visitRegistNoService;

    @Transactional
    public Integer addUserAndGroup(WebVisitGroupUser visitGroupUser) {
        WebVisitGroup visitGroup = new WebVisitGroup();
        BeanUtils.copyProperties((Object)visitGroupUser, (Object)visitGroup);
        visitGroup.setName(visitGroupUser.getCompany());
        visitGroup.setNumber(WebConstant.NUMBER);
        EntityDateUtil.supplementInsert((BaseEntity)visitGroup);
        this.webVisitGroupService.save((Object)visitGroup);
        EntityDateUtil.supplementInsert((BaseEntity)visitGroupUser);
        visitGroupUser.setNumber(WebConstant.NUMBER);
        visitGroupUser.setGroupId(visitGroup.getId());
        String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN_TEAM);
        visitGroupUser.setCardNo(cardNo);
        this.save((Object)visitGroupUser);
        return visitGroup.getId();
    }

    public WebVisitGroupUser findByMobile(String mobile) {
        LambdaQueryWrapper userLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebVisitGroupUser::getMobile, (Object)mobile)).eq(WebVisitGroupUser::getNumber, (Object)WebConstant.NUMBER);
        return (WebVisitGroupUser)this.getOne((Wrapper)userLambdaQueryWrapper);
    }

    public void updateGroupUserMaster(Integer id, Integer groupId) {
        WebVisitGroupUser groupUser = new WebVisitGroupUser();
        groupUser.setMaster(Boolean.valueOf(false));
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(WebVisitGroupUser::getGroupId, (Object)groupId);
        this.update((Object)groupUser, (Wrapper)updateWrapper);
        groupUser.setMaster(Boolean.valueOf(true));
        updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(WebVisitGroupUser::getGroupId, (Object)groupId)).eq(WebVisitGroupUser::getId, (Object)id);
        this.update((Object)groupUser, (Wrapper)updateWrapper);
    }

    public List<WebVisitGroupUser> findByGroupId(Integer groupId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebVisitGroupUser::getGroupId, (Object)groupId)).eq(WebVisitGroupUser::getNumber, (Object)WebConstant.NUMBER);
        return this.list((Wrapper)queryWrapper);
    }

    public List<WebVisitGroupUser> findWaitSync() {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebVisitGroupUser::getSync, (Object)false)).eq(WebVisitGroupUser::getNumber, (Object)WebConstant.NUMBER);
        return this.list((Wrapper)queryWrapper);
    }

    public void updateSync(String ids) {
        List list = Arrays.asList(ids.split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().in(WebVisitGroupUser::getId, list);
        WebVisitGroupUser info = new WebVisitGroupUser();
        info.setSync(Boolean.valueOf(true));
        EntityDateUtil.supplementUpdate((BaseEntity)info);
        this.update((Object)info, (Wrapper)updateWrapper);
    }
}

