/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.wx.controller;

import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wx/portal/{appid}"})
public class WxPortalController {
    private static final Logger log = LoggerFactory.getLogger(WxPortalController.class);
    private final WxMpService wxService;
    private final WxMpMessageRouter messageRouter;

    @GetMapping(produces={"text/plain;charset=utf-8"})
    public String authGet(@PathVariable String appid, @RequestParam(name="signature", required=false) String signature, @RequestParam(name="timestamp", required=false) String timestamp, @RequestParam(name="nonce", required=false) String nonce, @RequestParam(name="echostr", required=false) String echostr) {
        log.info("\n\u63a5\u6536\u5230\u6765\u81ea\u5fae\u4fe1\u670d\u52a1\u5668\u7684\u8ba4\u8bc1\u6d88\u606f\uff1a[{}, {}, {}, {}]", new Object[]{signature, timestamp, nonce, echostr});
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{signature, timestamp, nonce, echostr})) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6838\u5b9e!");
        }
        if (!this.wxService.switchover(appid)) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u5bf9\u5e94appid=[%s]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", appid));
        }
        if (this.wxService.checkSignature(timestamp, nonce, signature)) {
            return echostr;
        }
        return "\u975e\u6cd5\u8bf7\u6c42";
    }

    @PostMapping(produces={"application/xml; charset=UTF-8"})
    public String post(@PathVariable String appid, @RequestBody String requestBody, @RequestParam(value="signature") String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestParam(value="openid") String openid, @RequestParam(name="encrypt_type", required=false) String encType, @RequestParam(name="msg_signature", required=false) String msgSignature) {
        log.info("\n\u63a5\u6536\u5fae\u4fe1\u8bf7\u6c42\uff1a[openid=[{}], [signature=[{}], encType=[{}], msgSignature=[{}], timestamp=[{}], nonce=[{}], requestBody=[\n{}\n] ", new Object[]{openid, signature, encType, msgSignature, timestamp, nonce, requestBody});
        if (!this.wxService.switchover(appid)) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u5bf9\u5e94appid=[%s]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", appid));
        }
        if (!this.wxService.checkSignature(timestamp, nonce, signature)) {
            throw new IllegalArgumentException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u53ef\u80fd\u5c5e\u4e8e\u4f2a\u9020\u7684\u8bf7\u6c42\uff01");
        }
        String out = null;
        if (encType == null) {
            WxMpXmlMessage inMessage = WxMpXmlMessage.fromXml((String)requestBody);
            WxMpXmlOutMessage outMessage = this.route(inMessage);
            if (outMessage == null) {
                return "";
            }
            out = outMessage.toXml();
        } else if ("aes".equalsIgnoreCase(encType)) {
            WxMpXmlMessage inMessage = WxMpXmlMessage.fromEncryptedXml((String)requestBody, (WxMpConfigStorage)this.wxService.getWxMpConfigStorage(), (String)timestamp, (String)nonce, (String)msgSignature);
            log.debug("\n\u6d88\u606f\u89e3\u5bc6\u540e\u5185\u5bb9\u4e3a\uff1a\n{} ", (Object)inMessage.toString());
            WxMpXmlOutMessage outMessage = this.route(inMessage);
            if (outMessage == null) {
                return "";
            }
            out = outMessage.toEncryptedXml(this.wxService.getWxMpConfigStorage());
        }
        log.debug("\n\u7ec4\u88c5\u56de\u590d\u4fe1\u606f\uff1a{}", out);
        return out;
    }

    private WxMpXmlOutMessage route(WxMpXmlMessage message) {
        try {
            return this.messageRouter.route(message);
        }
        catch (Exception e) {
            log.error("\u8def\u7531\u6d88\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    public WxPortalController(WxMpService wxService, WxMpMessageRouter messageRouter) {
        this.wxService = wxService;
        this.messageRouter = messageRouter;
    }
}

