/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.common.configuration;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.ites.web.common.interceptor.MyContextInterceptor;
import com.ites.web.common.interceptor.WxInterceptor;
import com.ites.web.common.serializer.DateDeserializer;
import com.ites.web.common.serializer.DateSerializer;
import com.ites.web.common.serializer.DoubleSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class AppConfiguration
implements WebMvcConfigurer {
    @Resource
    private MyContextInterceptor myContextInterceptor;
    @Resource
    private WxInterceptor wxInterceptor;

    @Bean
    public CorsFilter corsFilter() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        corsConfiguration.setMaxAge(Long.valueOf(3600L));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", corsConfiguration);
        return new CorsFilter((CorsConfigurationSource)source);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.myContextInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/static/**"}).excludePathPatterns(new String[]{"/webjars/springfox-swagger-ui/**"}).excludePathPatterns(new String[]{"/swagger-resources/**"}).excludePathPatterns(new String[]{"/v2/api-docs"}).excludePathPatterns(new String[]{"/swagger-ui.html"});
        registry.addInterceptor((HandlerInterceptor)this.wxInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/static/**"}).excludePathPatterns(new String[]{"/webjars/springfox-swagger-ui/**"}).excludePathPatterns(new String[]{"/swagger-resources/**"}).excludePathPatterns(new String[]{"/v2/api-docs"}).excludePathPatterns(new String[]{"/swagger-ui.html"});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/static/"});
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    @Bean
    @Primary
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
        return builder -> builder.serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).serializerByType(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss"))).deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).deserializerByType(LocalTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss"))).serializerByType(Long.class, (JsonSerializer)new ToStringSerializer()).serializerByType(Double.class, (JsonSerializer)new DoubleSerializer()).serializerByType(Date.class, (JsonSerializer)new DateSerializer()).deserializerByType(Date.class, (JsonDeserializer)new DateDeserializer());
    }
}

