/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.download.controller;

import com.ites.web.basic.entity.BasicUser;
import com.ites.web.basic.service.BasicUserService;
import com.ites.web.common.context.MyContext;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.session.MySession;
import com.ites.web.common.valid.interfaces.Insert;
import com.ites.web.download.dto.WebDownloadLogDTO;
import com.ites.web.download.entity.WebDownload;
import com.ites.web.download.entity.WebDownloadLog;
import com.ites.web.download.service.WebDownloadLogService;
import com.ites.web.download.service.WebDownloadService;
import com.ites.web.sms.manager.SmsManager;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e0b\u8f7d\u65e5\u5fd7\u8868 API"})
public class WebDownloadLogController
extends BaseController {
    @Resource
    private WebDownloadLogService webDownloadLogService;
    @Autowired
    private BasicUserService basicUserService;
    @Autowired
    private WebDownloadService webDownloadService;
    @Resource
    private SmsManager smsManager;

    @PostMapping
    @ApiOperation(value="\u4fdd\u5b58\u4e0b\u8f7d\u8bb0\u5f55", httpMethod="POST")
    public Result save(@RequestBody @Validated(value={Insert.class}) WebDownloadLogDTO dto) {
        BasicUser basicUser = (BasicUser)this.basicUserService.getById((Serializable)MyContext.userId());
        BeanUtils.copyProperties((Object)dto, (Object)basicUser);
        this.basicUserService.updateById((Object)basicUser);
        MySession session = MyContext.session();
        BeanUtils.copyProperties((Object)basicUser, (Object)session);
        this.redisManager.set(this.request.getHeader("Access-Token"), (Object)session);
        MyContext.session((MySession)session);
        WebDownload webDownload = (WebDownload)this.webDownloadService.getById((Serializable)dto.getDownloadId());
        WebDownloadLog webDownloadLog = new WebDownloadLog();
        webDownloadLog.setUserId(Integer.valueOf(session.getUserId()));
        webDownloadLog.setDownloadId(dto.getDownloadId());
        webDownloadLog.setCreateTime(LocalDateTime.now());
        this.webDownloadLogService.save((Object)webDownloadLog);
        return R.ok((Object)webDownload.getFileUrl());
    }
}

