/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.email.manager;

import com.alibaba.dubbo.config.annotation.Reference;
import com.google.common.collect.Maps;
import com.ites.web.exhibitor.entity.WebBoothReserve;
import com.ites.web.utils.QrcodeUtil;
import com.ites.web.visit.entity.VisitRegistInfo;
import com.ites.web.visit.entity.VisitRegistInfoEn;
import com.simm.publicservice.export.LDCXEmailServiceExport;
import com.simm.publicservice.pojo.ldcx.EmailDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Component
public class EmailManager {
    private static final Logger log = LoggerFactory.getLogger(EmailManager.class);
    @Reference
    private LDCXEmailServiceExport ldcxEmailServiceExport;
    @Resource
    private JavaMailSender mailSender;
    @Value(value="${spring.mail.username}")
    private String username;
    @Resource
    private TemplateEngine templateEngine;

    public void sendVisitRegisterEmail(VisitRegistInfo info) {
        this.sendVisitEmail(info.getName(), info.getCardNo(), info.getEmail());
    }

    public void sendVisitRegisterEmailEn(VisitRegistInfoEn info) {
        this.sendEmail(info.getEmail(), String.format("ITES %s Registration Confirmation", "2023"), this.getEnglishRegisterEmailContent(info));
    }

    private void sendEmail(String email, String subject, String content) {
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
            helper.setFrom(this.username);
            helper.setTo(email);
            helper.setSubject(subject);
            helper.setText(content, true);
            this.mailSender.send(mimeMessage);
        }
        catch (Exception e) {
            log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private String getEnglishRegisterEmailContent(VisitRegistInfoEn visitRegisterInfoEn) {
        Context context = new Context();
        context.setVariable("firstName", (Object)visitRegisterInfoEn.getFirstName());
        context.setVariable("lastName", (Object)visitRegisterInfoEn.getLastName());
        context.setVariable("cardNo", (Object)visitRegisterInfoEn.getCardNo());
        context.setVariable("qrCode", (Object)QrcodeUtil.createQRCode((String)visitRegisterInfoEn.getCardNo(), (int)300, (int)300, (String)"en"));
        return this.templateEngine.process("visit_regist", (IContext)context);
    }

    private void sendVisitEmail(String name, String cardNo, String email) {
        HashMap replaces = Maps.newHashMap();
        replaces.put("{$preRegist_name}", name);
        replaces.put("{$preRegist_cardNo}", cardNo);
        String language = "cn";
        replaces.put("{$preRegist_imageUrl}", QrcodeUtil.createQRCode((String)cardNo, (int)200, (int)200, (String)language));
        EmailDTO emailDto = new EmailDTO();
        emailDto.setEmailName("2023 ITES\u6df1\u5733\u5de5\u4e1a\u5c55\u9884\u767b\u8bb0\u786e\u8ba4\u51fd");
        emailDto.setEmailType("2");
        emailDto.setContent("web-admin/mediaResource/\u9884\u767b\u8bb0\u786e\u8ba42023.html");
        emailDto.setSubject("2023 ITES\u6df1\u5733\u5de5\u4e1a\u5c55\u9884\u767b\u8bb0\u786e\u8ba4\u51fd");
        emailDto.setReplaces((Map)replaces);
        ArrayList<String> list = new ArrayList<String>();
        list.add(email);
        emailDto.setContackList(list);
        this.ldcxEmailServiceExport.sendNotifyEmail(emailDto);
    }

    public void sendBoothReserveEmail(String email, WebBoothReserve webBoothReserve) {
        EmailDTO emailDto = new EmailDTO();
        emailDto.setEmailName("2023 ITES\u6df1\u5733\u5de5\u4e1a\u5c55-\u5c55\u4f4d\u9884\u8ba2");
        emailDto.setEmailType("1");
        String content = "";
        content = content + "\u5c55\u4f4d\u9884\u8ba2\u63d0\u9192\uff1a\n";
        content = content + "\n\u5c55\u4f1a\u540d\uff1a" + webBoothReserve.getExhibitType();
        content = content + "\n\u516c\u53f8\u540d\uff1a" + webBoothReserve.getCompany();
        content = content + "\n\u59d3\u540d\uff1a" + webBoothReserve.getContact();
        content = content + "\n\u8054\u7cfb\u7535\u8bdd\uff1a" + webBoothReserve.getMobile();
        content = content + "\n\u6765\u6e90\uff1a" + webBoothReserve.getSource();
        emailDto.setContent(content);
        emailDto.setSubject("2023 ITES\u6df1\u5733\u5de5\u4e1a\u5c55-\u5c55\u4f4d\u9884\u8ba2");
        ArrayList<String> contackList = new ArrayList<String>();
        contackList.add(email);
        emailDto.setContackList(contackList);
        this.ldcxEmailServiceExport.sendNotifyEmail(emailDto);
    }
}

