/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.exhibitor.controller;

import cn.keking.anti_reptile.annotation.AntiReptile;
import com.alibaba.dubbo.config.annotation.Reference;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageInfo;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.valid.interfaces.Insert;
import com.ites.web.exhibitor.entity.ExhibitorCounsellingLog;
import com.ites.web.exhibitor.service.ExhibitorCounsellingLogService;
import com.ites.web.exhibitor.vo.ExhibitorInfoExhibitVO;
import com.ites.web.exhibitor.vo.ExhibitorInfoVO;
import com.ites.web.exhibitor.vo.SmebSiteActivityVO;
import com.ites.web.sms.manager.SmsManager;
import com.ites.web.utils.DateUtil;
import com.ites.web.utils.JsonUtil;
import com.ites.web.utils.http.HttpUtil;
import com.ites.web.wx.annotation.ExculdeWxSecurity;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import com.simm.exhibitor.bean.basic.SmebExhibitorInfo;
import com.simm.exhibitor.bean.exhibitors.SmebExhibitorInfoExhibit;
import com.simm.exhibitor.bean.exhibitors.SmebSiteActivityDTO;
import com.simm.exhibitor.export.SmebExhibitorInfoServiceExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5c55\u5546\u5217\u8868\u63a5\u53e3"})
public class ExhibitorController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ExhibitorController.class);
    @Reference
    private SmebExhibitorInfoServiceExport smebExhibitorInfoServiceExport;
    @Resource
    private SmsManager smsManager;
    @Autowired
    private ExhibitorCounsellingLogService counsellingLogService;
    @Value(value="${exhibitor.rankUrl}")
    private String exhibitorRankUrl;

    @PostMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u5c55\u5546\u5206\u9875\u67e5\u8be2", httpMethod="POST")
    public Result findPage(@RequestBody SmebExhibitorInfo smebExhibitorInfo) {
        this.conversion(smebExhibitorInfo);
        smebExhibitorInfo.setApproveStatus(Integer.valueOf(1));
        smebExhibitorInfo.setNumber(WebConstant.NUMBER);
        PageInfo page = this.smebExhibitorInfoServiceExport.findItemByPage(smebExhibitorInfo);
        ArrayList<ExhibitorInfoVO> vos = new ArrayList<ExhibitorInfoVO>();
        for (SmebExhibitorInfo info : page.getList()) {
            ExhibitorInfoVO vo = new ExhibitorInfoVO();
            BeanUtils.copyProperties((Object)info, (Object)vo);
            this.beautifyData(info, vo);
            vos.add(vo);
        }
        Page pageVos = new Page((long)page.getPageNum(), (long)page.getPageSize(), page.getTotal());
        pageVos.setRecords(vos);
        return R.ok((Object)pageVos);
    }

    @GetMapping
    @AntiReptile
    @ExculdeWxSecurity
    @ApiOperation(value="\u5c55\u5546\u8be6\u60c5", httpMethod="GET")
    public Result<ExhibitorInfoVO> findById(@PathVariable(value="id") Integer id) {
        SmebExhibitorInfo info = this.smebExhibitorInfoServiceExport.findInfoById(id);
        ExhibitorInfoVO vo = new ExhibitorInfoVO();
        BeanUtils.copyProperties((Object)info, (Object)vo);
        this.beautifyData(info, vo);
        List siteActivityDTOList = info.getSiteActivityDTOList();
        ArrayList<SmebSiteActivityVO> siteActivityVOS = new ArrayList<SmebSiteActivityVO>();
        for (SmebSiteActivityDTO siteActivityDTO : siteActivityDTOList) {
            SmebSiteActivityVO siteActivityVO = SmebSiteActivityVO.builder().id(siteActivityDTO.getId()).title(siteActivityDTO.getTitle()).titleName(siteActivityDTO.getTitleName()).startTime(DateUtil.formatDateTime((Date)siteActivityDTO.getStartTime())).endTime(DateUtil.formatDateTime((Date)siteActivityDTO.getEndTime())).build();
            siteActivityVOS.add(siteActivityVO);
        }
        vo.setSiteActivityDTOList(siteActivityVOS);
        String result = HttpUtil.get((String)(this.exhibitorRankUrl + "/" + info.getUniqueId()));
        JSONObject object = JSONObject.fromObject((Object)result);
        JSONObject data = object.getJSONObject("data");
        if (ObjectUtils.isNotEmpty((Object)data)) {
            vo.setInviteCount(Integer.valueOf(data.getInt("inviteCount")));
            vo.setRank(Integer.valueOf(data.getInt("rank")));
            vo.setDifference(Integer.valueOf(data.getInt("difference")));
        }
        List exhibits = this.smebExhibitorInfoServiceExport.listExhibitByExhibitorInfoId(id);
        ArrayList<ExhibitorInfoExhibitVO> exhibitVOS = new ArrayList<ExhibitorInfoExhibitVO>();
        for (SmebExhibitorInfoExhibit exhibit : exhibits) {
            ExhibitorInfoExhibitVO exhibitVO = new ExhibitorInfoExhibitVO();
            exhibitVO.setImgUrl(exhibit.getImgUrl());
            exhibitVO.setName(exhibit.getName());
            exhibitVO.setIntroduce(exhibit.getIntroduce());
            exhibitVO.setNewFlag(exhibit.getNewFlag());
            exhibitVO.setType(exhibit.getType());
            exhibitVOS.add(exhibitVO);
        }
        vo.setExhibitList(exhibitVOS);
        log.info("\u5c55\u5546\u8be6\u60c5: {}", (Object)JsonUtil.toJson((Object)vo));
        return R.ok((Object)vo);
    }

    private void beautifyData(SmebExhibitorInfo info, ExhibitorInfoVO vo) {
        String brandNameEn;
        String applicationIndustryEn;
        String brandName;
        String applicationIndustry = info.getApplicationIndustry();
        if (StringUtils.isNotBlank((CharSequence)applicationIndustry)) {
            applicationIndustry = applicationIndustry.replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("\"", "");
            vo.setApplicationIndustry(applicationIndustry);
        }
        if (StringUtils.isNotBlank((CharSequence)(brandName = info.getBrandName()))) {
            ArrayList<String> brandNames = new ArrayList<String>();
            JSONArray json = JSONArray.fromObject((Object)brandName);
            for (int i = 0; i < json.size(); ++i) {
                JSONObject job = json.getJSONObject(i);
                brandNames.add(String.valueOf(job.get("name")));
            }
            vo.setBrandNames(brandNames);
        }
        if (StringUtils.isNotBlank((CharSequence)(applicationIndustryEn = info.getApplicationIndustryEn()))) {
            applicationIndustryEn = applicationIndustryEn.replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("\"", "");
            vo.setApplicationIndustryEn(applicationIndustryEn);
        }
        if (StringUtils.isNotBlank((CharSequence)(brandNameEn = info.getBrandNameEn()))) {
            ArrayList<String> brandNameEns = new ArrayList<String>();
            JSONArray json = JSONArray.fromObject((Object)brandNameEn);
            for (int i = 0; i < json.size(); ++i) {
                JSONObject job = json.getJSONObject(i);
                brandNameEns.add(String.valueOf(job.get("name")));
            }
            vo.setBrandNameEns(brandNameEns);
        }
    }

    @PostMapping
    @ApiOperation(value="\u63d0\u4ea4\u54a8\u8be2\u4fe1\u606f", httpMethod="POST")
    public Result saveCounsellingLog(@RequestBody @Validated(value={Insert.class}) ExhibitorCounsellingLog counsellingLog) {
        boolean b = this.smsManager.validation(counsellingLog.getSmsCode(), counsellingLog.getMobile());
        if (!b) {
            return R.failure();
        }
        boolean result = this.counsellingLogService.saveAndSendEmail(counsellingLog);
        if (!result) {
            R.failure();
        }
        return R.ok();
    }

    private void conversion(SmebExhibitorInfo info) {
        if (ObjectUtils.isEmpty((Object)info)) {
            return;
        }
        if (null != info.getCountryName()) {
            switch (info.getCountryName()) {
                case "zg": {
                    info.setCountryName("\u4e2d\u56fd");
                    break;
                }
                case "zgtw": {
                    info.setCountryName("\u4e2d\u56fd\u53f0\u6e7e");
                    break;
                }
                case "zgxg": {
                    info.setCountryName("\u4e2d\u56fd\u9999\u6e2f");
                    break;
                }
                case "dg": {
                    info.setCountryName("\u5fb7\u56fd");
                    break;
                }
                case "rb": {
                    info.setCountryName("\u65e5\u672c");
                    break;
                }
                case "mg": {
                    info.setCountryName("\u7f8e\u56fd");
                    break;
                }
                case "hg": {
                    info.setCountryName("\u97e9\u56fd");
                    break;
                }
                case "ydl": {
                    info.setCountryName("\u610f\u5927\u5229");
                    break;
                }
                case "rs": {
                    info.setCountryName("\u745e\u58eb");
                    break;
                }
                case "rd": {
                    info.setCountryName("\u745e\u5178");
                    break;
                }
            }
        }
        if (null != info.getExhibitionAreaClassify()) {
            switch (info.getExhibitionAreaClassify()) {
                case "all": {
                    info.setExhibitionAreaClassify("\u5168\u90e8");
                    break;
                }
                case "xianjinzhizaojishu": {
                    info.setExhibitionAreaClassify("\u5148\u8fdb\u5236\u9020\u6280\u672f\uff087/5\u9986\uff09");
                    break;
                }
                case "wuzhoujichuang": {
                    info.setExhibitionAreaClassify("\u4e94\u8f74\u673a\u5e8a\uff087\u9986\uff09");
                    break;
                }
                case "longmenjichuang": {
                    info.setExhibitionAreaClassify("\u9f99\u95e8\u673a\u5e8a\uff087\u9986\uff09");
                    break;
                }
                case "jingmishukongjichuang": {
                    info.setExhibitionAreaClassify("\u7cbe\u5bc6\u6570\u63a7\u673a\u5e8a\uff085\u9986\uff09");
                    break;
                }
                case "dianjiagongjichuang": {
                    info.setExhibitionAreaClassify("\u7535\u52a0\u5de5\u673a\u5e8a\uff085\u9986\uff09");
                    break;
                }
                case "gongyeceliang": {
                    info.setExhibitionAreaClassify("\u5de5\u4e1a\u6d4b\u91cf\uff087/5\u9986\uff09");
                    break;
                }
                case "qitajinqie": {
                    info.setExhibitionAreaClassify("\u5176\u4ed6\u91d1\u5207\u76f8\u5173\u4ea7\u54c1\uff087/5\u9986\uff09");
                    break;
                }
                case "jiguangbanjinjiagong": {
                    info.setExhibitionAreaClassify("\u6fc0\u5149\u94a3\u91d1\u52a0\u5de5\u53ca\u81ea\u52a8\u5316\u8bbe\u5907\uff088\u9986\uff09");
                    break;
                }
                case "jiguangjingmihanjie": {
                    info.setExhibitionAreaClassify("\u6fc0\u5149\u7cbe\u5bc6\u710a\u63a5\uff088\u9986\uff09");
                    break;
                }
                case "jiguangjingmiqiege": {
                    info.setExhibitionAreaClassify("\u6fc0\u5149\u7cbe\u5bc6\u5207\u5272\uff088\u9986\uff09");
                    break;
                }
                case "jiguangdabiao": {
                    info.setExhibitionAreaClassify("\u6fc0\u5149\u6253\u6807\u53ca\u6e05\u6d17\uff088\u9986\uff09");
                    break;
                }
                case "jingmichongya": {
                    info.setExhibitionAreaClassify("\u7cbe\u5bc6\u51b2\u538b\u53ca\u81ea\u52a8\u5316\u8bbe\u5907\uff088\u9986\uff09");
                    break;
                }
                case "qitabanjinxiangguan": {
                    info.setExhibitionAreaClassify("\u5176\u4ed6\u94a3\u91d1\u76f8\u5173\u4ea7\u54c1\uff088\u9986\uff09");
                    break;
                }
                case "daojugongju": {
                    info.setExhibitionAreaClassify("\u5200\u5177\u5de5\u5177\uff086\u9986\uff09");
                    break;
                }
                case "jingmijiagong": {
                    info.setExhibitionAreaClassify("\u7cbe\u5bc6\u52a0\u5de5\u96f6\u4ef6\uff086\u9986\uff09");
                    break;
                }
                case "jiazhiju": {
                    info.setExhibitionAreaClassify("\u5939\u6cbb\u5177\uff086\u9986\uff09");
                    break;
                }
                case "mujujimujupeijian": {
                    info.setExhibitionAreaClassify("\u6a21\u5177\u53ca\u6a21\u5177\u914d\u4ef6\uff086\u9986\uff09");
                    break;
                }
                case "gongyecailiao": {
                    info.setExhibitionAreaClassify("\u5de5\u4e1a\u6750\u6599\uff086\u9986\uff09");
                    break;
                }
                case "jingujian": {
                    info.setExhibitionAreaClassify("\u7d27\u56fa\u4ef6\uff086\u9986\uff09");
                    break;
                }
                case "qitadaojuxiangguan": {
                    info.setExhibitionAreaClassify("\u5176\u4ed6\u5200\u5177\u76f8\u5173\u4ea7\u54c1\uff086\u9986\uff09");
                    break;
                }
                case "jichuanghexingongneng": {
                    info.setExhibitionAreaClassify("\u673a\u5e8a\u6838\u5fc3\u529f\u80fd\u90e8\u4ef6\u6280\u672f\uff087/5\u9986\uff09");
                    break;
                }
                case "zengcaizhizao": {
                    info.setExhibitionAreaClassify("\u589e\u6750\u5236\u9020\uff086\u9986\uff09");
                    break;
                }
                case "sanweisaomiao": {
                    info.setExhibitionAreaClassify("\u4e09\u7ef4\u626b\u63cf\u53ca\u6d4b\u91cf\uff086\u9986\uff09");
                    break;
                }
                case "qitagongyelingjian": {
                    info.setExhibitionAreaClassify("\u5176\u4ed6\u5de5\u4e1a\u96f6\u4ef6\u76f8\u5173\u4ea7\u54c1\uff086\u9986\uff09");
                    break;
                }
                case "xiezuojiqiren": {
                    info.setExhibitionAreaClassify("\u673a\u5668\u4eba/\u534f\u4f5c\u673a\u5668\u4eba\u53ca\u5e94\u7528\u65b9\u6848\uff084\u9986\uff09");
                    break;
                }
                case "3Cfeibiaoshebei": {
                    info.setExhibitionAreaClassify("3C\u975e\u6807\u8bbe\u5907\uff084\u9986\uff09");
                    break;
                }
                case "jiqirenshijue": {
                    info.setExhibitionAreaClassify("\u673a\u5668\u4eba\u89c6\u89c9\u53ca\u65b9\u6848\uff084\u9986\uff09");
                    break;
                }
                case "suoluosi": {
                    info.setExhibitionAreaClassify("\u9501\u87ba\u4e1d/\u710a\u9521/\u70b9\u80f6\uff084\u9986\uff09");
                    break;
                }
                case "zhinenggongliao": {
                    info.setExhibitionAreaClassify("\u667a\u80fd\u4f9b\u6599/\u632f\u52a8\u76d8\uff084\u9986\uff09");
                    break;
                }
                case "dianqiyeya": {
                    info.setExhibitionAreaClassify("\u7535\u6c14\u6db2\u538b\u6267\u884c\u673a\u6784\uff084\u9986\uff09");
                    break;
                }
                case "qitajiqiren": {
                    info.setExhibitionAreaClassify("\u5176\u4ed6\u673a\u5668\u4eba/\u81ea\u52a8\u5316\u8bbe\u5907\u76f8\u5173\u4ea7\u54c1\uff084\u9986\uff09");
                    break;
                }
                case "zhinenghanjie": {
                    info.setExhibitionAreaClassify("\u667a\u80fd\u710a\u63a5\uff082\u9986\uff09");
                    break;
                }
                case "damopaoguang": {
                    info.setExhibitionAreaClassify("\u6253\u78e8\u629b\u5149\uff082\u9986\uff09");
                    break;
                }
                case "zhinengningjin": {
                    info.setExhibitionAreaClassify("\u667a\u80fd\u62e7\u7d27/\u94c6\u63a5/\u538b\u63a5\uff082\u9986\uff09");
                    break;
                }
                case "sigang": {
                    info.setExhibitionAreaClassify("\u4e1d\u6760\u5bfc\u8f68\u3001\u6a21\u5177\uff082\u9986\uff09");
                    break;
                }
                case "zhoucheng": {
                    info.setExhibitionAreaClassify("\u8f74\u627f\uff082\u9986\uff09");
                    break;
                }
                case "jiansuji": {
                    info.setExhibitionAreaClassify("\u51cf\u901f\u673a/\u9f7f\u8f6e\u9f7f\u6761\u7b49\u4f20\u52a8\u4ef6\uff082\u9986\uff09");
                    break;
                }
                case "qitachuangdong": {
                    info.setExhibitionAreaClassify("\u5176\u4ed6\u4f20\u52a8\u76f8\u5173\u4ea7\u54c1\uff082\u9986\uff09");
                    break;
                }
                case "yidongjiqiren": {
                    info.setExhibitionAreaClassify("\u79fb\u52a8\u673a\u5668\u4eba/AGV\uff082\u9986\uff09");
                    break;
                }
                case "cangchujishu": {
                    info.setExhibitionAreaClassify("\u4ed3\u50a8\u6280\u672f\u53ca\u8bbe\u5907\uff082\u9986\uff09");
                    break;
                }
                case "baozhuangshebei": {
                    info.setExhibitionAreaClassify("\u5305\u88c5\u8bbe\u5907\u53ca\u65b9\u6848\uff082\u9986\uff09");
                    break;
                }
                case "zhinengshusongshebei": {
                    info.setExhibitionAreaClassify("\u667a\u80fd\u8f93\u9001\u8bbe\u5907\uff082\u9986\uff09");
                    break;
                }
                case "qitawuliuxiangguan": {
                    info.setExhibitionAreaClassify("\u5176\u4ed6\u7269\u6d41\u76f8\u5173\u4ea7\u54c1\uff082\u9986\uff09");
                    break;
                }
                case "gongyefuwu": {
                    info.setExhibitionAreaClassify("\u5de5\u4e1a\u670d\u52a1\uff082\u9986\uff09");
                    break;
                }
                case "kongzhixitong": {
                    info.setExhibitionAreaClassify("\u63a7\u5236\u7cfb\u7edf\uff083\u9986\uff09");
                    break;
                }
                case "dianqixitong": {
                    info.setExhibitionAreaClassify("\u7535\u6c14\u7cfb\u7edf\uff083\u9986\uff09");
                    break;
                }
                case "ganyingjishu": {
                    info.setExhibitionAreaClassify("\u611f\u5e94\u6280\u672f\uff083\u9986\uff09");
                    break;
                }
                case "lianjiejishu": {
                    info.setExhibitionAreaClassify("\u8fde\u63a5\u6280\u672f\uff083\u9986\uff09");
                    break;
                }
                case "qidongzhixing": {
                    info.setExhibitionAreaClassify("\u6c14\u52a8\u6267\u884c\u673a\u6784\uff083\u9986\uff09");
                    break;
                }
                case "qitayunkong": {
                    info.setExhibitionAreaClassify("\u5176\u4ed6\u8fd0\u63a7\u76f8\u5173\u4ea7\u54c1\uff083\u9986\uff09");
                    break;
                }
                case "u4leidianhdmi": {
                    info.setExhibitionAreaClassify("U4/\u96f7\u75354/HDMI2.1/\u82f9\u679cPD\uff083\u9986\uff09");
                    break;
                }
                case "dianxian": {
                    info.setExhibitionAreaClassify("\u7535\u7ebf/\u8fde\u63a5\u5668/\u7ebf\u675f\u672b\u7aef/\u81ea\u52a8\u5316\u8bbe\u5907\uff083\u9986\uff09");
                    break;
                }
                case "gaosuxianlan": {
                    info.setExhibitionAreaClassify("\u9ad8\u901f\u7ebf\u7f06DAC/AOC\u4ea7\u4e1a\u94fe\uff083\u9986\uff09");
                    break;
                }
                case "qitaxianlan": {
                    info.setExhibitionAreaClassify("\u5176\u4ed6\u7ebf\u7f06\u76f8\u5173\u4ea7\u54c1\uff083\u9986\uff09");
                    break;
                }
                case "dianzizhizao": {
                    info.setExhibitionAreaClassify("\u7535\u5b50\u5236\u9020\uff082\u9986\uff09");
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (null != info.getApplicationIndustry()) {
            switch (info.getApplicationIndustry()) {
                case "jjg": {
                    info.setApplicationIndustry("\u673a\u52a0\u5de5/\u7cbe\u5bc6\u96f6\u4ef6\u5236\u9020");
                    break;
                }
                case "jc": {
                    info.setApplicationIndustry("\u673a\u5e8a\u53ca\u76f8\u5173\u884c\u4e1a");
                    break;
                }
                case "fb": {
                    info.setApplicationIndustry("\u975e\u6807\u8bbe\u5907\u53ca\u81ea\u52a8\u5316\u96c6\u6210");
                    break;
                }
                case "mj": {
                    info.setApplicationIndustry("\u6a21\u5177\u53ca\u914d\u4ef6");
                    break;
                }
                case "qc": {
                    info.setApplicationIndustry("\u6c7d\u8f66\u3001\u6469\u6258\u8f66\u6574\u8f66\u53ca\u96f6\u90e8\u4ef6");
                    break;
                }
                case "xny": {
                    info.setApplicationIndustry("\u65b0\u80fd\u6e90\u6280\u672f");
                    break;
                }
                case "3C": {
                    info.setApplicationIndustry("3C\u53ca\u7535\u5b50\u5236\u9020");
                    break;
                }
                case "jd": {
                    info.setApplicationIndustry("\u5bb6\u7535\u53ca\u53a8\u536b");
                    break;
                }
                case "yl": {
                    info.setApplicationIndustry("\u533b\u7597\u5668\u68b0\u3001\u751f\u7269\u79d1\u6280");
                    break;
                }
                case "gtx": {
                    info.setApplicationIndustry("\u5149\u901a\u4fe1\u3001\u534a\u5bfc\u4f53\u3001\u7167\u660e\u53ca\u5e94\u7528");
                    break;
                }
                case "zb": {
                    info.setApplicationIndustry("\u949f\u8868\u3001\u73e0\u5b9d\u3001\u773c\u955c\u7b49\u5236\u54c1");
                    break;
                }
                case "jxzz": {
                    info.setApplicationIndustry("\u673a\u68b0\u53ca\u673a\u68b0\u914d\u4ef6\u5236\u9020");
                    break;
                }
                case "wl": {
                    info.setApplicationIndustry("\u7269\u6d41\u8fd0\u8f93\u3001\u5305\u88c5\u5370\u5237");
                    break;
                }
                case "hkht": {
                    info.setApplicationIndustry("\u822a\u7a7a\u822a\u5929\u3001\u94c1\u8def\u53ca\u8f68\u9053\u4ea4\u901a");
                    break;
                }
                case "gyhl": {
                    info.setApplicationIndustry("\u5de5\u4e1a\u4e92\u8054\u7f51\u3001\u7269\u8054\u7f51");
                    break;
                }
            }
        }
    }
}

