/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.home.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.home.service.WebHomePageBannerService;
import com.ites.web.home.vo.WebHomePageBannerVO;
import com.ites.web.home.vo.WebHomePageVO;
import com.ites.web.media.service.WebNewsService;
import com.ites.web.media.vo.WebNewsVO;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9996\u9875 API"})
public class WebHomeController
extends BaseController {
    @Resource
    private WebHomePageBannerService webHomePageBannerService;
    @Resource
    private WebNewsService webNewsService;

    @GetMapping
    @ApiOperation(value="\u9996\u9875API", httpMethod="GET", notes="\u9996\u9875API")
    public Result<WebHomePageVO> home() {
        int language = this.getLanguage();
        Object obj = this.redisManager.get("banner_cache_" + language);
        if (ObjectUtils.isNotEmpty((Object)obj)) {
            return R.ok((Object)((WebHomePageVO)obj));
        }
        WebHomePageVO vo = new WebHomePageVO();
        List list = this.webHomePageBannerService.findByLanguage(language);
        List vos = BaseVO.conversion((List)list, WebHomePageBannerVO.class);
        vo.setBannerVos(vos);
        List leftWebNews = this.webNewsService.findHomeLeftNews(language);
        List leftWebNewsVos = BaseVO.conversion((List)leftWebNews, WebNewsVO.class);
        vo.setLeftNewsVos(leftWebNewsVos);
        Page rightNews = this.webNewsService.findHomeRightNews(new Page(1L, 5L), language);
        List rightWebNewsVos = BaseVO.conversion((List)rightNews.getRecords(), WebNewsVO.class);
        vo.setRightNewsVos(rightWebNewsVos);
        this.redisManager.set("banner_cache_" + language, (Object)vo, (long)WebConstant.TIME_OUT.intValue());
        return R.ok((Object)vo);
    }
}

