/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.landing.controller;

import com.ites.web.common.controller.BaseController;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.landing.service.WebLandingPageBannerService;
import com.ites.web.landing.service.WebLandingPageCaseService;
import com.ites.web.landing.service.WebLandingPageExhibitorsService;
import com.ites.web.landing.service.WebLandingPageExhibitsService;
import com.ites.web.landing.service.WebLandingPageMeetingService;
import com.ites.web.landing.service.WebLandingPageVideoService;
import com.ites.web.landing.vo.WebLandingPageBannerVO;
import com.ites.web.landing.vo.WebLandingPageCaseVO;
import com.ites.web.landing.vo.WebLandingPageExhibitsVO;
import com.ites.web.landing.vo.WebLandingPageMeetingVO;
import com.ites.web.landing.vo.WebLandingPageVO;
import com.ites.web.landing.vo.WebLandingPageVideoVO;
import com.ites.web.meeting.entity.WebMeeting;
import com.ites.web.meeting.entity.WebMeetingTheme;
import com.ites.web.meeting.service.WebMeetingService;
import com.ites.web.meeting.service.WebMeetingThemeService;
import com.ites.web.meeting.vo.WebMeetingThemeVO;
import com.ites.web.topic.vo.WebTopicPageExhibitorsVO;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7740\u9646\u9875\u4ee3\u8868\u5c55\u5546 API"})
public class WebLandingPageController
extends BaseController {
    @Resource
    private WebLandingPageExhibitorsService webLandingPageExhibitorsService;
    @Resource
    private WebMeetingThemeService webMeetingThemeService;
    @Resource
    private WebLandingPageBannerService webLandingPageBannerService;
    @Resource
    private WebLandingPageCaseService webLandingPageCaseService;
    @Resource
    private WebLandingPageVideoService webLandingPageVideoService;
    @Resource
    private WebLandingPageExhibitsService webLandingPageExhibitsService;
    @Resource
    private WebLandingPageMeetingService webLandingPageMeetingService;
    @Resource
    private WebMeetingService webMeetingService;

    @GetMapping
    @ApiOperation(value="\u7740\u9646\u9875", httpMethod="GET")
    public Result<WebLandingPageVO> home(@PathVariable(value="year") String year, @PathVariable(value="landingId") Integer landingId) {
        int language = this.getLanguage();
        List banners = this.webLandingPageBannerService.findByLandingIdAndYear(landingId, language, year);
        List bannerVos = BaseVO.conversion((List)banners, WebLandingPageBannerVO.class);
        List videos = this.webLandingPageVideoService.findByLandingIdAndYear(landingId, language, year);
        List videoVos = BaseVO.conversion((List)videos, WebLandingPageVideoVO.class);
        List exhibits = this.webLandingPageExhibitsService.findByLandingIdAndYear(landingId, language, year);
        List exhibitVos = BaseVO.conversion((List)exhibits, WebLandingPageExhibitsVO.class);
        List cases = this.webLandingPageCaseService.findByLandingIdAndYear(landingId, language, year);
        List caseVos = BaseVO.conversion((List)cases, WebLandingPageCaseVO.class);
        WebMeetingTheme webMeetingTheme = new WebMeetingTheme();
        webMeetingTheme.setIsLanding(Boolean.valueOf(true));
        List meetingThemes = this.webMeetingThemeService.findList(webMeetingTheme);
        List meetingThemeVos = BaseVO.conversion((List)meetingThemes, WebMeetingThemeVO.class);
        List meetings = this.webLandingPageMeetingService.findByLandingIdAndYear(landingId, language, year);
        List meetingVos = null;
        if (!CollectionUtils.isEmpty((Collection)meetings)) {
            meetingVos = BaseVO.conversion((List)meetings, WebLandingPageMeetingVO.class);
            List list = this.webMeetingService.findListByIds(meetings.stream().map(v -> v.getMeetingId()).collect(Collectors.toList()));
            Map map = list.stream().collect(Collectors.toMap(WebMeeting::getId, Function.identity(), (key1, key2) -> key2));
            meetingVos.stream().forEach(m -> {
                WebMeeting webMeeting = (WebMeeting)map.get(m.getMeetingId());
                m.setBigTitle(webMeeting.getBigTitle());
                m.setTitle(webMeeting.getTitle());
                m.setAddress(webMeeting.getAddress());
                m.setStartTime(webMeeting.getStartTime());
                m.setEndTime(webMeeting.getEndTime());
                m.setHoldDate(webMeeting.getHoldDate());
                m.setYear(webMeeting.getYear());
                m.setThumbnailUrl(webMeeting.getThumbnailUrl());
            });
        }
        List exhibitorss = this.webLandingPageExhibitorsService.findByLandingIdAndYear(landingId, language, year);
        List exhibitiorsVos = BaseVO.conversion((List)exhibitorss, WebTopicPageExhibitorsVO.class);
        WebLandingPageVO vo = new WebLandingPageVO();
        vo.setBannerVos(bannerVos);
        vo.setVideoVos(videoVos);
        vo.setExhibitVos(exhibitVos);
        vo.setCaseVos(caseVos);
        vo.setMeetingThemeVos(meetingThemeVos);
        vo.setMeetingVos(meetingVos);
        vo.setExhibitiorsVos(exhibitiorsVos);
        return R.ok((Object)vo);
    }
}

