/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.media.controller;

import com.ites.web.common.controller.BaseController;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.media.service.WebAdminSeoPageTitleService;
import com.ites.web.media.vo.WebAdminSeoPageTitleVO;
import com.ites.web.wx.annotation.ExculdeWxSecurity;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"SEO\u9875\u9762\u6807\u9898\u914d\u7f6e\u8868 API"})
public class WebAdminSeoPageTitleController
extends BaseController {
    @Resource
    private WebAdminSeoPageTitleService webAdminSeoPageTitleService;

    @GetMapping
    public Result clean() {
        this.redisManager.set("seo_cache_", null);
        return R.ok();
    }

    @PostMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u6839\u636e\u8bf7\u6c42url\u67e5\u8be2SEO\u4fe1\u606f", httpMethod="POST")
    public Result findByRequestURL(String requestUrl) {
        List vos = (List)this.redisManager.get("seo_cache_");
        if (ObjectUtils.isEmpty((Object)vos)) {
            List webAdminSeoPageTitles = this.webAdminSeoPageTitleService.list();
            vos = BaseVO.conversion((List)webAdminSeoPageTitles, WebAdminSeoPageTitleVO.class);
            this.redisManager.set("seo_cache_", (Object)vos, 86400L);
        }
        WebAdminSeoPageTitleVO vo = this.findByURL(vos, requestUrl);
        return R.ok((Object)vo);
    }

    private WebAdminSeoPageTitleVO findByURL(List<WebAdminSeoPageTitleVO> vos, String requestUrl) {
        int language = this.getLanguage();
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        Optional<WebAdminSeoPageTitleVO> cartOptional = vos.stream().filter(item -> requestUrl.equals(item.getRequestUri()) && language == item.getLanguage()).findFirst();
        if (cartOptional.isPresent()) {
            return cartOptional.get();
        }
        Optional<WebAdminSeoPageTitleVO> first = vos.stream().filter(item -> item.getIsDefault() != false && language == item.getLanguage()).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        return null;
    }
}

