/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.media.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.media.dao.WebNewsDao;
import com.ites.web.media.entity.WebNews;
import com.ites.web.media.service.WebNewsService;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="webNewsService")
public class WebNewsServiceImpl
extends ServiceImpl<WebNewsDao, WebNews>
implements WebNewsService {
    @Resource
    private WebNewsDao webNewsDao;

    public Page<WebNews> findPage(WebNews webNews) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper((Object)webNews).ne(ObjectUtils.isNotEmpty((Object)webNews.getId()), WebNews::getId, (Object)webNews.getId())).in(ObjectUtils.isNotEmpty((Object)webNews.getLanguage()), WebNews::getLanguage, Arrays.asList(webNews.getLanguage(), WebConstant.LANGUAGE_PUBLIC))).eq(WebNews::getIsOnline, (Object)true)).and(StringUtils.isNotEmpty((CharSequence)webNews.getSearchKey()), i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(WebNews::getKeyword, (Object)webNews.getSearchKey())).or()).like(WebNews::getContent, (Object)webNews.getSearchKey())).or()).like(WebNews::getTitle, (Object)webNews.getSearchKey()));
        queryWrapper.orderByDesc((Object[])new SFunction[]{WebNews::getIsTop, WebNews::getCreateTime});
        return (Page)this.page((IPage)new Page((long)webNews.getPageNum().intValue(), (long)webNews.getPageSize().intValue()), (Wrapper)queryWrapper);
    }

    public List<WebNews> findlistByLabel(Integer id, String label) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(ObjectUtils.isNotEmpty((Object)id), WebNews::getId, (Object)id)).like(StringUtils.isNotEmpty((CharSequence)label), WebNews::getLabel, (Object)label)).eq(WebNews::getIsOnline, (Object)true);
        return this.list((Wrapper)queryWrapper);
    }

    public List<WebNews> findHomeLeftNews(int language) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(WebNews::getLanguage, Arrays.asList(language, WebConstant.LANGUAGE_PUBLIC))).eq(WebNews::getIsHomepageBanner, (Object)true)).eq(WebNews::getIsOnline, (Object)true);
        queryWrapper.orderByDesc((Object[])new SFunction[]{WebNews::getIsTop, WebNews::getCreateTime});
        return this.list((Wrapper)queryWrapper);
    }

    public Page<WebNews> findHomeRightNews(Page page, int language) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(WebNews::getLanguage, Arrays.asList(language, WebConstant.LANGUAGE_PUBLIC))).eq(WebNews::getIsHomepageDisplay, (Object)true)).eq(WebNews::getIsOnline, (Object)true);
        queryWrapper.orderByDesc((Object[])new SFunction[]{WebNews::getIsTop, WebNews::getCreateTime});
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }

    public Page<WebNews> findPageByKeyword(String keyword) {
        WebNews webNews = new WebNews();
        webNews.setKeyword(keyword);
        return this.findPage(webNews);
    }

    public Page<WebNews> findPageByExhibitonId(Integer exhibitionId, int language) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(WebNews::getLanguage, Arrays.asList(language, WebConstant.LANGUAGE_PUBLIC))).like(WebNews::getExhibitionIds, (Object)exhibitionId)).eq(WebNews::getIsOnline, (Object)true);
        queryWrapper.orderByDesc((Object[])new SFunction[]{WebNews::getIsTop, WebNews::getCreateTime});
        return (Page)this.page((IPage)new Page(0L, 5L), (Wrapper)queryWrapper);
    }

    public void addCount(Integer id) {
        this.webNewsDao.addCount(id);
    }
}

