/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.meeting.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.context.MyContext;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.meeting.entity.WebMeeting;
import com.ites.web.meeting.entity.WebMeetingEnroll;
import com.ites.web.meeting.entity.WebMeetingExtend;
import com.ites.web.meeting.service.WebMeetingAttendListService;
import com.ites.web.meeting.service.WebMeetingChargeModeService;
import com.ites.web.meeting.service.WebMeetingDataService;
import com.ites.web.meeting.service.WebMeetingEnrollService;
import com.ites.web.meeting.service.WebMeetingGuestService;
import com.ites.web.meeting.service.WebMeetingImageService;
import com.ites.web.meeting.service.WebMeetingOrganizationsService;
import com.ites.web.meeting.service.WebMeetingService;
import com.ites.web.meeting.vo.WebMeetingAttendListVO;
import com.ites.web.meeting.vo.WebMeetingChargeModeVO;
import com.ites.web.meeting.vo.WebMeetingDataVO;
import com.ites.web.meeting.vo.WebMeetingGuestVO;
import com.ites.web.meeting.vo.WebMeetingImageVO;
import com.ites.web.meeting.vo.WebMeetingOrganizationsVO;
import com.ites.web.meeting.vo.WebMeetingVO;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f1a\u8bae\u8868 API"})
public class WebMeetingController
extends BaseController {
    @Resource
    private WebMeetingService webMeetingService;
    @Resource
    private WebMeetingEnrollService webMeetingEnrollService;
    @Resource
    private WebMeetingChargeModeService webMeetingChargeModeService;
    @Resource
    private WebMeetingImageService webMeetingImageService;
    @Resource
    private WebMeetingDataService webMeetingDataService;
    @Resource
    private WebMeetingAttendListService webMeetingAttendListService;
    @Resource
    private WebMeetingGuestService webMeetingGuestService;
    @Resource
    private WebMeetingOrganizationsService webMeetingOrganizationsService;

    @PostMapping
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", httpMethod="POST")
    public Result<Page<WebMeetingVO>> findPage(@RequestBody WebMeetingExtend webMeeting) {
        Page page = this.webMeetingService.findPage(webMeeting);
        Page pageVOs = BaseVO.conversion((Page)page, WebMeetingVO.class);
        List records = pageVOs.getRecords();
        Integer userId = MyContext.userId();
        records.forEach(v -> {
            if (v.getIsCharge().booleanValue()) {
                List list = this.webMeetingChargeModeService.findByMId(v.getId());
                List chargeModeVos = BaseVO.conversion((List)list, WebMeetingChargeModeVO.class);
                v.setChargeModeVos(chargeModeVos);
            }
            if (MyContext.isLogin()) {
                WebMeetingEnroll meetingEnroll = this.webMeetingEnrollService.findByUIdAndMId(userId, v.getId());
                if (ObjectUtils.isEmpty((Object)meetingEnroll)) {
                    v.setEnrollStatus(WebConstant.MEETING_ENROLL_NO);
                } else if (ObjectUtils.isEmpty((Object)meetingEnroll.getChargeModeId())) {
                    v.setEnrollStatus(WebConstant.MEETING_ENROLL_YES);
                } else {
                    v.setEnrollStatus(meetingEnroll.getChargeStatus() != false ? WebConstant.MEETING_ENROLL_YES : WebConstant.MEETING_ENROLL_PAY);
                }
            }
        });
        return R.ok((Object)pageVOs);
    }

    @GetMapping
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e", httpMethod="GET")
    public Result<WebMeetingVO> findById(@PathVariable(value="id") Integer id) {
        WebMeeting webMeeting = (WebMeeting)this.webMeetingService.getById((Serializable)id);
        if (!webMeeting.getIsOnline().booleanValue()) {
            return R.ok();
        }
        WebMeetingVO vo = (WebMeetingVO)BaseVO.conversion((BaseEntity)webMeeting, WebMeetingVO.class);
        if (MyContext.isLogin()) {
            WebMeetingEnroll meetingEnroll = this.webMeetingEnrollService.findByUIdAndMId(MyContext.userId(), vo.getId());
            if (ObjectUtils.isEmpty((Object)meetingEnroll)) {
                vo.setEnrollStatus(WebConstant.MEETING_ENROLL_NO);
            } else if (ObjectUtils.isEmpty((Object)meetingEnroll.getChargeModeId())) {
                vo.setEnrollStatus(WebConstant.MEETING_ENROLL_YES);
            } else {
                vo.setEnrollStatus(meetingEnroll.getChargeStatus() != false ? WebConstant.MEETING_ENROLL_YES : WebConstant.MEETING_ENROLL_PAY);
            }
        }
        if (vo.getIsCharge().booleanValue()) {
            List list = this.webMeetingChargeModeService.findByMId(vo.getId());
            List chargeModeVos = BaseVO.conversion((List)list, WebMeetingChargeModeVO.class);
            vo.setChargeModeVos(chargeModeVos);
        }
        this.supplement(id, webMeeting.getKeyword(), vo);
        return R.ok((Object)vo);
    }

    private void supplement(Integer meetingId, String keyword, WebMeetingVO vo) {
        List images = this.webMeetingImageService.findByMId(meetingId);
        List meetingImageVos = BaseVO.conversion((List)images, WebMeetingImageVO.class);
        vo.setMeetingImageVos(meetingImageVos);
        List guests = this.webMeetingGuestService.findByMId(meetingId);
        List guestVos = BaseVO.conversion((List)guests, WebMeetingGuestVO.class);
        vo.setGuestVos(guestVos);
        List datas = this.webMeetingDataService.findByMId(meetingId);
        List dataVos = BaseVO.conversion((List)datas, WebMeetingDataVO.class);
        vo.setDataVos(dataVos);
        List attendLists = this.webMeetingAttendListService.findByMId(meetingId);
        List attendListVos = BaseVO.conversion((List)attendLists, WebMeetingAttendListVO.class);
        vo.setAttendListVos(attendListVos);
        List organizationss = this.webMeetingOrganizationsService.findByMId(meetingId);
        List organizationsVos = BaseVO.conversion((List)organizationss, WebMeetingOrganizationsVO.class);
        HashMap<String, WebMeetingOrganizationsVO> recipientsMap = new HashMap<String, WebMeetingOrganizationsVO>();
        for (WebMeetingOrganizationsVO organizationsVO : organizationsVos) {
            ArrayList<WebMeetingOrganizationsVO> organizationsVoList;
            String key = organizationsVO.getName();
            WebMeetingOrganizationsVO organizationsVoKey = (WebMeetingOrganizationsVO)recipientsMap.get(key);
            if (ObjectUtils.isEmpty((Object)organizationsVoKey)) {
                organizationsVoKey = new WebMeetingOrganizationsVO();
                organizationsVoKey.setName(key);
                recipientsMap.put(key, organizationsVoKey);
            }
            if (CollectionUtils.isEmpty((Collection)(organizationsVoList = organizationsVoKey.getOrganizationsVos()))) {
                organizationsVoList = new ArrayList<WebMeetingOrganizationsVO>();
            }
            organizationsVoList.add(organizationsVO);
            organizationsVoKey.setOrganizationsVos(organizationsVoList);
        }
        ArrayList organizationsVOList = new ArrayList(recipientsMap.values());
        vo.setOrganizationsVos(organizationsVOList);
        WebMeetingExtend meeting = new WebMeetingExtend();
        meeting.setKeyword(keyword);
        meeting.setPageSize(Integer.valueOf(3));
        meeting.setPageNum(Integer.valueOf(1));
        Page page = this.webMeetingService.findPage(meeting);
        List webMeetingVos = BaseVO.conversion((List)page.getRecords(), WebMeetingVO.class);
        vo.setMeetingVos(webMeetingVos);
    }

    @GetMapping
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e", httpMethod="GET")
    public Result<WebMeetingVO> findStatisticsById(@PathVariable(value="id") Integer id) {
        WebMeeting webMeeting = (WebMeeting)this.webMeetingService.getById((Serializable)id);
        WebMeetingVO vo = (WebMeetingVO)BaseVO.conversion((BaseEntity)webMeeting, WebMeetingVO.class);
        List enrollList = this.webMeetingEnrollService.findListByMeetingId(vo.getId());
        vo.setEnrolls((long)enrollList.size());
        long count = enrollList.stream().filter(v -> v != null && v.getSign() != null && v.getSign() != false).count();
        vo.setSigns(count);
        vo.setNoSings(vo.getEnrolls() - count);
        long sceneCount = enrollList.stream().filter(v -> StringUtils.equals((CharSequence)"meetingScene", (CharSequence)v.getSource())).count();
        vo.setScenes(sceneCount);
        return R.ok((Object)vo);
    }
}

