/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.meeting.service.impl;

import com.alibaba.dubbo.config.annotation.Reference;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ites.web.meeting.dao.WebMeetingEnrollDao;
import com.ites.web.meeting.entity.WebMeeting;
import com.ites.web.meeting.entity.WebMeetingEnroll;
import com.ites.web.meeting.service.WebMeetingEnrollService;
import com.ites.web.meeting.service.WebMeetingService;
import com.simm.publicservice.export.SmsServiceExport;
import com.simm.publicservice.pojo.Resp;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="webMeetingEnrollService")
public class WebMeetingEnrollServiceImpl
extends ServiceImpl<WebMeetingEnrollDao, WebMeetingEnroll>
implements WebMeetingEnrollService {
    @Reference
    private SmsServiceExport smsServiceExport;
    @Autowired
    private WebMeetingService webMeetingService;

    public WebMeetingEnroll findByUIdAndMId(Integer userId, Integer meetingId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebMeetingEnroll::getUserId, (Object)userId)).eq(WebMeetingEnroll::getMeetingId, (Object)meetingId);
        return (WebMeetingEnroll)this.getOne((Wrapper)queryWrapper);
    }

    public List<WebMeetingEnroll> findByUId(Integer userId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebMeetingEnroll::getUserId, (Object)userId);
        return this.list((Wrapper)queryWrapper);
    }

    public List<WebMeetingEnroll> findByUIdAndMIds(Integer userId, List<Integer> meetingIds) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebMeetingEnroll::getUserId, (Object)userId)).in(WebMeetingEnroll::getMeetingId, meetingIds);
        return this.list((Wrapper)queryWrapper);
    }

    public void sendMessage(WebMeetingEnroll webMeetingEnroll) {
        String content = "\u5c0a\u656c\u7684" + webMeetingEnroll.getName() + "\uff0c\u60a8\u597d\uff01\u60a8\u5df2\u6210\u529f\u62a5\u540d\u672c\u6b21\u4f1a\u8bae\uff0c\u671f\u5f85\u60a8\u51c6\u65f6\u53c2\u52a0\uff01 \u3010ITES\u6df1\u5733\u5de5\u4e1a\u5c55\u3011";
        WebMeeting webMeeting = (WebMeeting)this.webMeetingService.getById((Serializable)webMeetingEnroll.getMeetingId());
        if (StringUtils.isNotEmpty((CharSequence)webMeeting.getSmsContent()) && (content = webMeeting.getSmsContent().replace("{\u59d3\u540d}", webMeetingEnroll.getName())).indexOf("\u3010ITES\u6df1\u5733\u5de5\u4e1a\u5c55\u3011") == -1) {
            content = content + "\u3010ITES\u6df1\u5733\u5de5\u4e1a\u5c55\u3011";
        }
        Resp resp = this.smsServiceExport.sendMsg(webMeetingEnroll.getMobile(), content);
        this.log.debug("sendMessage=================>" + resp.toString());
    }

    public WebMeetingEnroll findByChargeLogId(Integer chargeLogId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WebMeetingEnroll::getChargeLogId, (Object)chargeLogId);
        List list = this.list((Wrapper)queryWrapper);
        return CollectionUtils.isEmpty((Collection)list) ? null : (WebMeetingEnroll)list.get(0);
    }

    public WebMeetingEnroll findByMobileAndMeetingId(String mobile, Integer id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(WebMeetingEnroll::getMobile, (Object)mobile)).eq(WebMeetingEnroll::getMeetingId, (Object)id);
        List list = this.list((Wrapper)queryWrapper);
        return CollectionUtils.isEmpty((Collection)list) ? null : (WebMeetingEnroll)list.get(0);
    }

    public List<WebMeetingEnroll> findListByMeetingId(Integer meetingId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebMeetingEnroll::getMeetingId, (Object)meetingId);
        return this.list((Wrapper)queryWrapper);
    }
}

