/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.meeting.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.context.MyContext;
import com.ites.web.meeting.dao.WebMeetingDao;
import com.ites.web.meeting.entity.WebMeeting;
import com.ites.web.meeting.entity.WebMeetingExtend;
import com.ites.web.meeting.service.WebMeetingEnrollService;
import com.ites.web.meeting.service.WebMeetingService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="webMeetingService")
public class WebMeetingServiceImpl
extends ServiceImpl<WebMeetingDao, WebMeeting>
implements WebMeetingService {
    @Resource
    private WebMeetingEnrollService webMeetingEnrollService;

    public Page<WebMeeting> findPage(WebMeetingExtend webMeeting) {
        List list;
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebMeeting::getIsOnline, (Object)true)).eq(ObjectUtils.isNotEmpty((Object)webMeeting.getIsRegistPage()), WebMeeting::getIsRegistPage, (Object)webMeeting.getIsRegistPage())).eq(ObjectUtils.isNotEmpty((Object)webMeeting.getType()), WebMeeting::getType, (Object)webMeeting.getType())).eq(ObjectUtils.isNotEmpty((Object)webMeeting.getThemeId()), WebMeeting::getThemeId, (Object)webMeeting.getThemeId())).like(ObjectUtils.isNotEmpty((Object)webMeeting.getKeyword()), WebMeeting::getKeyword, (Object)webMeeting.getKeyword())).eq(ObjectUtils.isNotEmpty((Object)webMeeting.getYear()), WebMeeting::getYear, (Object)webMeeting.getYear())).eq(ObjectUtils.isNotEmpty((Object)webMeeting.getSearchDate()), WebMeeting::getHoldDate, (Object)webMeeting.getSearchDate());
        if (ObjectUtils.isNotEmpty((Object)webMeeting.getSearchKey())) {
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(WebMeeting::getBigTitle, (Object)webMeeting.getSearchKey())).or()).like(WebMeeting::getLabel, (Object)webMeeting.getSearchKey())).or()).like(WebMeeting::getTitle, (Object)webMeeting.getSearchKey()));
        }
        if (WebConstant.MEETING_STATUS_BEGIN.equals(webMeeting.getMeetingStatus())) {
            queryWrapper.le(WebMeeting::getEndTime, (Object)LocalDateTime.now());
        } else if (WebConstant.MEETING_STATUS_END.equals(webMeeting.getMeetingStatus())) {
            queryWrapper.ge(WebMeeting::getEndTime, (Object)LocalDateTime.now());
        }
        if (WebConstant.MEETING_ENROLL_YES.equals(webMeeting.getEnrollStatus()) && MyContext.isLogin() && !CollectionUtils.isEmpty((Collection)(list = this.webMeetingEnrollService.findByUId(MyContext.userId())))) {
            List meetingIds = list.stream().map(v -> v.getMeetingId()).collect(Collectors.toList());
            queryWrapper.in(WebMeeting::getId, meetingIds);
        }
        queryWrapper.last("order by is_top desc,end_time<now(),if(end_time<now(),0,end_time),end_time desc");
        return (Page)this.page((IPage)new Page((long)webMeeting.getPageNum().intValue(), (long)webMeeting.getPageSize().intValue()), (Wrapper)queryWrapper);
    }

    public List<WebMeeting> findList(WebMeeting webMeeting) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)webMeeting);
        queryWrapper.last("order by is_top desc,end_time<now(),if(end_time<now(),0,end_time),end_time desc");
        return this.list((Wrapper)queryWrapper);
    }

    public List<WebMeeting> findListByIds(List<Integer> ids) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebMeeting::getIsOnline, (Object)true)).in(WebMeeting::getId, ids);
        return this.list((Wrapper)queryWrapper);
    }

    public List<WebMeeting> findThemeList(WebMeeting webMeeting, String year) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper((Object)webMeeting).gt(WebMeeting::getStartTime, (Object)year)).isNotNull(WebMeeting::getThemeId);
        queryWrapper.last("order by is_top desc,end_time<now(),if(end_time<now(),0,end_time),end_time desc");
        return this.list((Wrapper)queryWrapper);
    }
}

