/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.prize.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ites.web.prize.dao.PrizeLightLogDao;
import com.ites.web.prize.entity.PrizeLightLog;
import com.ites.web.prize.service.PrizeLightLogService;
import com.ites.web.prize.service.PrizeLightNoService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="prizeLightLogService")
public class PrizeLightLogServiceImpl
extends ServiceImpl<PrizeLightLogDao, PrizeLightLog>
implements PrizeLightLogService {
    @Resource
    private PrizeLightNoService prizeLightNoService;

    public PrizeLightLog findByOpenId(String openId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PrizeLightLog::getOpenId, (Object)openId);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (PrizeLightLog)list.get(0);
    }

    public PrizeLightLog findByNo(Integer no) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PrizeLightLog::getPrizeNo, (Object)no);
        return (PrizeLightLog)this.getOne((Wrapper)queryWrapper);
    }

    public void updateApplyStatus(PrizeLightLog prizeLightLog) {
        prizeLightLog.setIsApply(Boolean.valueOf(true));
        this.updateById((Object)prizeLightLog);
    }

    public PrizeLightLog goToPrize(String openId) {
        String prizeNo = this.prizeLightNoService.getPrizeNo();
        if (prizeNo == null) {
            return null;
        }
        PrizeLightLog log = new PrizeLightLog();
        log.setOpenId(openId);
        log.setPrizeNo(prizeNo);
        log.setPrizeTime(LocalDateTime.now());
        this.save((Object)log);
        return log;
    }
}

