/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    public static Date stringToDate(String stringDate) {
        if (ObjectUtils.isEmpty((Object)stringDate)) {
            return null;
        }
        return DateUtil.string2Date((String)stringDate, (String)"yyyy-MM-dd");
    }

    public static Date stringToDateLong(String stringDate) {
        return DateUtil.string2Date((String)stringDate, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static Date string2Date(String stringDate, String pas) {
        Date reDate;
        if (ObjectUtils.isEmpty((Object)stringDate)) {
            return null;
        }
        try {
            reDate = new SimpleDateFormat(pas).parse(stringDate);
        }
        catch (ParseException var4) {
            var4.printStackTrace();
            reDate = null;
        }
        return reDate;
    }

    public static String toDate(Date datetime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return null == datetime ? null : sdf.format(datetime);
    }

    public static String toDate(Date datetime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return null == datetime ? null : sdf.format(datetime);
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static LocalDate dateToLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalDate();
    }

    public static LocalTime dateToLocalTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalTime();
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static String localDateTimeToString(LocalDateTime localDateTime) {
        if (ObjectUtils.isEmpty((Object)localDateTime)) {
            return null;
        }
        return localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String localDateTimeToString(LocalDateTime localDateTime, String format) {
        if (ObjectUtils.isEmpty((Object)localDateTime)) {
            return null;
        }
        return localDateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static Date localDateToDate(LocalDate localDate) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static String formatDateTime(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }
}

