/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.utils;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.BucketInfo;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.ites.web.common.oss.properties.OssProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class OssUtil {
    private static String endpoint;
    private static String url;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String bucketName;

    public static void init(OssProperties properties) {
        endpoint = properties.getEndpoint();
        url = properties.getUrl();
        accessKeyId = properties.getAccessKeyId();
        accessKeySecret = properties.getAccessKeySecret();
        bucketName = properties.getBucketName();
    }

    public static OSSClient getOSSClient() {
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        return ossClient;
    }

    public static void shutdown(OSSClient ossClient) {
        ossClient.shutdown();
    }

    public static boolean existAndCreateBucket(String bucketName) {
        OSSClient ossClient = OssUtil.getOSSClient();
        if (ossClient.doesBucketExist(bucketName)) {
            return true;
        }
        ossClient.createBucket(bucketName);
        OssUtil.shutdown((OSSClient)ossClient);
        return false;
    }

    public static BucketInfo getBucketInfo(String bucketName) {
        OSSClient ossClient = OssUtil.getOSSClient();
        BucketInfo info = ossClient.getBucketInfo(bucketName);
        OssUtil.shutdown((OSSClient)ossClient);
        return info;
    }

    public static List<OSSObjectSummary> getBucketObjectInfo(String bucketName) {
        OSSClient ossClient = OssUtil.getOSSClient();
        ObjectListing objectListing = ossClient.listObjects(bucketName);
        List objectSummary = objectListing.getObjectSummaries();
        OssUtil.shutdown((OSSClient)ossClient);
        return objectSummary;
    }

    public static String uploadObject(InputStream is, String filePath) {
        return OssUtil.uploadObject((InputStream)is, (String)filePath, null);
    }

    public static String uploadObject(InputStream is, String filePath, String bucketNameCite) {
        OSSClient ossClient = OssUtil.getOSSClient();
        String fileUrl = null;
        if (StringUtils.isBlank((CharSequence)bucketNameCite)) {
            ossClient.putObject(bucketName, filePath, is);
            fileUrl = "http://" + bucketName + "." + url + filePath;
        } else {
            ossClient.putObject(bucketNameCite, filePath, is);
            fileUrl = "http://" + bucketNameCite + "." + url + filePath;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException var6) {
                var6.printStackTrace();
            }
        }
        OssUtil.shutdown((OSSClient)ossClient);
        return fileUrl;
    }

    public static String uploadObject(String serverFilePath, String filePath, String bucketNameCite) {
        OSSClient ossClient = OssUtil.getOSSClient();
        String fileUrl = null;
        if (StringUtils.isBlank((CharSequence)bucketNameCite)) {
            ossClient.putObject(bucketName, filePath, new File(serverFilePath));
            fileUrl = "http://" + bucketName + "." + url + filePath;
        } else {
            ossClient.putObject(bucketNameCite, filePath, new File(serverFilePath));
            fileUrl = "http://" + bucketNameCite + "." + url + filePath;
        }
        OssUtil.shutdown((OSSClient)ossClient);
        return fileUrl;
    }

    public static StringBuilder downloadObject(String fileName, String bucketNameCite) throws IOException {
        OSSClient ossClient = OssUtil.getOSSClient();
        OSSObject ossObject = null;
        ossObject = StringUtils.isBlank((CharSequence)bucketNameCite) ? ossClient.getObject(bucketName, fileName) : ossClient.getObject(bucketNameCite, fileName);
        InputStream inputStream = ossObject.getObjectContent();
        StringBuilder objectContent = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) {
                reader.close();
                inputStream.close();
                OssUtil.shutdown((OSSClient)ossClient);
                return objectContent;
            }
            objectContent.append(line);
        }
    }

    public static void deleteObject(String fileName, String bucketNameCite) {
        OSSClient ossClient = OssUtil.getOSSClient();
        if (StringUtils.isNotBlank((CharSequence)bucketNameCite)) {
            ossClient.deleteObject(bucketNameCite, fileName);
        }
        OssUtil.shutdown((OSSClient)ossClient);
    }
}

