/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.controller;

import com.ites.web.common.controller.BaseController;
import com.ites.web.common.valid.interfaces.Insert;
import com.ites.web.common.valid.interfaces.Update;
import com.ites.web.utils.IPUtil;
import com.ites.web.visit.entity.UserPreregistVisitLog;
import com.ites.web.visit.entity.VisitRegistInfo;
import com.ites.web.visit.service.UserPreregistVisitLogService;
import com.ites.web.visit.service.VisitRegistInfoService;
import com.ites.web.visit.vo.RegistDataVO;
import com.ites.web.visit.vo.SyncRegistDataVO;
import com.joneying.common.annotation.CommonController;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u540c\u6b65\u89c2\u4f17\u4fe1\u606f\u7ed9\u5408\u4f5c\u65b9"})
public class SyncRegistInfoController
extends BaseController {
    @Resource
    private VisitRegistInfoService visitRegistInfoService;
    @Resource
    private UserPreregistVisitLogService userPreregistVisitLogService;

    @PostMapping
    @CommonController(description="\u6279\u91cf\u83b7\u53d6\uff08\u5b58\u91cf\uff09\u9884\u767b\u8bb0\u6570\u636e")
    @ApiOperation(value="\u6279\u91cf\u83b7\u53d6\uff08\u5b58\u91cf\uff09\u9884\u767b\u8bb0\u6570\u636e", httpMethod="POST")
    public Result sync(@RequestBody @Validated(value={Insert.class}) SyncRegistDataVO vo) {
        String time = vo.getTime();
        String sign = vo.getSign();
        ArrayList<RegistDataVO> list = new ArrayList<RegistDataVO>();
        if (System.currentTimeMillis() - Long.parseLong(time) > 120000L) {
            this.recordSyncLog("5402");
            return R.failure((String)"5402");
        }
        String myToken = DigestUtils.md5Hex((String)(time + "4$Du*reNCeJ3Et,D8&hmwo%d^hc&-vd8u4")).substring(3, 17).toUpperCase();
        if (!myToken.equals(sign)) {
            this.recordSyncLog("5403");
            return R.failure((String)"5403");
        }
        List preList = this.visitRegistInfoService.getPrintInfo();
        if (null == preList || preList.size() == 0) {
            this.recordSyncLog("5404");
            return R.ok();
        }
        for (VisitRegistInfo info : preList) {
            RegistDataVO data = new RegistDataVO();
            data.setComName(StringUtils.hasLength((String)info.getCompany()) ? info.getCompany() : "");
            data.setName(StringUtils.hasLength((String)info.getName()) ? info.getName() : "");
            data.setNumber(info.getCardNo());
            data.setIdentityCard(info.getIdentityCard());
            list.add(data);
        }
        this.recordSyncLog("5404");
        return R.ok(list);
    }

    @PostMapping
    @CommonController(description="\u786e\u8ba4\u9884\u767b\u8bb0\u6570\u636e\u5df2\u6210\u529f\u63a5\u6536")
    @ApiOperation(value="\u786e\u8ba4\u9884\u767b\u8bb0\u6570\u636e\u5df2\u6210\u529f\u63a5\u6536", httpMethod="POST")
    public Result ack(@RequestBody @Validated(value={Update.class}) SyncRegistDataVO vo) {
        String time = vo.getTime();
        String sign = vo.getSign();
        List numbers = vo.getNumbers();
        if (System.currentTimeMillis() - Long.parseLong(time) > 120000L) {
            this.recordAckLog("5402");
            return R.failure((String)"5402");
        }
        String myToken = DigestUtils.md5Hex((String)(time + String.join((CharSequence)",", numbers) + "4$Du*reNCeJ3Et,D8&hmwo%d^hc&-vd8u4")).substring(3, 17).toUpperCase();
        if (!sign.equals(myToken)) {
            this.recordAckLog("5403");
            return R.failure((String)"5403");
        }
        boolean result = this.visitRegistInfoService.batchUpdateSyncFlag(numbers);
        if (result) {
            this.recordAckLog("5404");
            return R.ok((Object)true);
        }
        return R.failure();
    }

    private void recordSyncLog(String status) {
        this.recordLog("sync", status);
    }

    private void recordAckLog(String status) {
        this.recordLog("ack", status);
    }

    private void recordLog(String no, String status) {
        UserPreregistVisitLog log = new UserPreregistVisitLog();
        log.setNo(no);
        log.setStatus(status);
        log.setVtime(new Date());
        log.setIp(IPUtil.getIP((HttpServletRequest)this.request));
        log.setRequestHead(this.request.getHeader("user-agent"));
        this.userPreregistVisitLogService.save((Object)log);
    }
}

