/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ites.web.basic.entity.BasicUser;
import com.ites.web.basic.service.BasicUserService;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.context.MyContext;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.session.MySession;
import com.ites.web.common.valid.interfaces.Insert;
import com.ites.web.common.valid.interfaces.Update;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.meeting.entity.WebMeeting;
import com.ites.web.meeting.entity.WebMeetingEnroll;
import com.ites.web.meeting.entity.WebMeetingTheme;
import com.ites.web.meeting.service.WebMeetingEnrollService;
import com.ites.web.meeting.service.WebMeetingService;
import com.ites.web.meeting.service.WebMeetingThemeService;
import com.ites.web.meeting.vo.WebMeetingThemeExtendVO;
import com.ites.web.meeting.vo.WebMeetingVO;
import com.ites.web.sms.manager.SmsManager;
import com.ites.web.utils.DateUtil;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.utils.IPUtil;
import com.ites.web.utils.http.HttpUtil;
import com.ites.web.visit.entity.VisitRegistInfo;
import com.ites.web.visit.entity.VisitRegistInfoExtend;
import com.ites.web.visit.service.VisitRegistInfoService;
import com.ites.web.visit.service.VisitRegistNoService;
import com.ites.web.visit.vo.VisitRegistInfoVO;
import com.joneying.web.authentication.annotation.ExculdeSecurity;
import com.joneying.web.handler.annotation.DeleteMapping;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.handler.annotation.PutMapping;
import com.joneying.web.logger.annotation.CommonController;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import com.simm.publicservice.export.IdentityCardServiceExport;
import com.simm.publicservice.export.SmsServiceExport;
import com.simm.publicservice.export.WebPowerEmailServiceExport;
import com.simm.publicservice.pojo.Resp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u89c2\u4f17\u767b\u8bb0 API"})
public class VisitRegistInfoController
extends BaseController {
    @Resource
    private VisitRegistInfoService visitRegistInfoService;
    @Resource
    private VisitRegistNoService visitRegistNoService;
    @Resource
    private BasicUserService basicUserService;
    @Resource
    private WebMeetingThemeService webMeetingThemeService;
    @Resource
    private WebMeetingService webMeetingService;
    @Resource
    private WebMeetingEnrollService webMeetingEnrollService;
    @Resource
    private SmsManager smsManager;
    @Reference
    private SmsServiceExport smsServiceExport;
    @Reference
    private WebPowerEmailServiceExport webPowerEmailServiceExport;
    @Reference
    private IdentityCardServiceExport identityCardServiceExport;
    @Resource
    private ThreadPoolExecutor registryThreadPool;

    @GetMapping
    @CommonController(description="\u67e5\u8be2\u6211\u7684\u9884\u767b\u8bb0")
    @ApiOperation(value="\u67e5\u8be2\u6211\u7684\u9884\u767b\u8bb0", httpMethod="GET")
    public Result<VisitRegistInfoVO> findVisit() {
        MySession session = (MySession)this.request.getAttribute("Access-Token");
        if (ObjectUtils.isEmpty((Object)session)) {
            return R.ok();
        }
        VisitRegistInfo visitRegistInfo = this.visitRegistInfoService.findByUserId(session.getUserId());
        VisitRegistInfoVO vo = (VisitRegistInfoVO)BaseVO.conversion((BaseEntity)visitRegistInfo, VisitRegistInfoVO.class);
        if (ObjectUtils.isNotEmpty((Object)vo)) {
            vo.setIsPreSuccess(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)vo.getSmsStatus())));
        }
        return R.ok((Object)vo);
    }

    @GetMapping
    @CommonController(description="\u6839\u636e\u624b\u673a\u53f7\u7801\u67e5\u8be2\u9884\u767b\u8bb0")
    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u7801\u67e5\u8be2\u9884\u767b\u8bb0", httpMethod="GET")
    public Result<VisitRegistInfoVO> findByMobile(@PathVariable(value="mobile") String mobile, @PathVariable(value="code") String code) {
        VisitRegistInfoVO vo;
        boolean validation = this.smsManager.validation(mobile, code);
        if (!validation) {
            return R.failure((String)"5002");
        }
        VisitRegistInfo visitRegistInfo = this.visitRegistInfoService.findByMobile(mobile);
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo) && !MyContext.userId().equals(visitRegistInfo.getUserId())) {
            visitRegistInfo.setUserId(MyContext.userId());
            EntityDateUtil.supplementUpdate((BaseEntity)visitRegistInfo);
            this.visitRegistInfoService.updateById((Object)visitRegistInfo);
        }
        if (Objects.isNull(visitRegistInfo)) {
            visitRegistInfo = new VisitRegistInfo();
            visitRegistInfo.setUserId(MyContext.userId());
            visitRegistInfo.setMobile(mobile);
            visitRegistInfo.setNumbers(WebConstant.NUMBER);
            EntityDateUtil.supplementInsert((BaseEntity)visitRegistInfo);
            this.visitRegistInfoService.save((Object)visitRegistInfo);
        }
        if (ObjectUtils.isNotEmpty((Object)(vo = (VisitRegistInfoVO)BaseVO.conversion((BaseEntity)visitRegistInfo, VisitRegistInfoVO.class)))) {
            vo.setIsPreSuccess(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)vo.getSmsStatus())));
        }
        this.existsCompanyWeChatByPhone(visitRegistInfo);
        return R.ok((Object)vo);
    }

    @GetMapping
    @CommonController(description="\u67e5\u8be2\u5c55\u671f\u4f1a\u8bae")
    @ApiOperation(value="\u67e5\u8be2\u5c55\u671f\u4f1a\u8bae", httpMethod="GET")
    public Result findMeeting() {
        WebMeeting webMeeting = new WebMeeting();
        webMeeting.setType(WebConstant.MEETING_TYPE_EXHIBITION);
        webMeeting.setIsOnline(Boolean.valueOf(true));
        List list = this.webMeetingService.findThemeList(webMeeting, "2023");
        if (CollectionUtils.isEmpty((Collection)list)) {
            return R.ok();
        }
        List meetingVos = BaseVO.conversion((List)list, WebMeetingVO.class);
        Map<Integer, List<WebMeetingVO>> group = meetingVos.stream().collect(Collectors.groupingBy(e -> e.getThemeId()));
        List themes = this.webMeetingThemeService.findList(new WebMeetingTheme());
        List vos = BaseVO.conversion((List)themes, WebMeetingThemeExtendVO.class);
        vos.forEach(v -> {
            List meetings = (List)group.get(v.getId());
            v.setMeetingVos(meetings);
        });
        return R.ok((Object)vos);
    }

    @PostMapping
    @CommonController(description="\u62a5\u540d\u5c55\u671f\u4f1a\u8bae")
    @ApiOperation(value="\u62a5\u540d\u5c55\u671f\u4f1a\u8bae", httpMethod="POST")
    public Result enrollMetting(@RequestBody List<Integer> ids) {
        VisitRegistInfo visitRegistInfo = this.visitRegistInfoService.findBySession();
        ArrayList list = new ArrayList();
        List enrolls = this.webMeetingEnrollService.findByUId(visitRegistInfo.getUserId());
        Map<Object, Object> map = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)enrolls)) {
            map = enrolls.stream().collect(Collectors.toMap(WebMeetingEnroll::getId, Function.identity(), (key1, key2) -> key1));
        }
        HashMap finalMap = map;
        ids.forEach(v -> {
            if (finalMap.containsKey(v)) {
                return;
            }
            WebMeetingEnroll webMeetingEnroll = new WebMeetingEnroll();
            BeanUtils.copyProperties((Object)visitRegistInfo, (Object)webMeetingEnroll);
            webMeetingEnroll.setMeetingId(v);
            EntityDateUtil.supplementInsert((BaseEntity)webMeetingEnroll);
            list.add(webMeetingEnroll);
        });
        this.webMeetingEnrollService.saveBatch(list);
        return R.ok();
    }

    @PostMapping
    @CommonController(description="\u63d0\u4ea4\u95ee\u5377\u4fe1\u606f")
    @ApiOperation(value="\u63d0\u4ea4\u95ee\u5377\u4fe1\u606f", httpMethod="POST")
    public Result submitQuestion(@RequestBody @Validated(value={Update.class}) VisitRegistInfo visitRegist) {
        VisitRegistInfo visitRegistDB = (VisitRegistInfo)this.visitRegistInfoService.getById((Serializable)visitRegist.getId());
        visitRegistDB.setQuestion(visitRegist.getQuestion());
        String sceneDateTime = (String)this.redisManager.get("scene-date-time");
        Date date = DateUtil.stringToDateLong((String)sceneDateTime);
        String origin = this.request.getHeader("Origin");
        visitRegistDB.setSync(Boolean.valueOf(false));
        EntityDateUtil.supplementUpdate((BaseEntity)visitRegistDB);
        boolean result = this.visitRegistInfoService.updateById((Object)visitRegistDB);
        if (result) {
            VisitRegistInfoVO vo = (VisitRegistInfoVO)BaseVO.conversion((BaseEntity)visitRegistDB, VisitRegistInfoVO.class);
            vo.setIsPreSuccess(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)visitRegistDB.getSmsStatus())));
            return R.ok((Object)vo);
        }
        return R.failure();
    }

    @GetMapping
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e", httpMethod="GET")
    public Result<VisitRegistInfoVO> findByCardNo(@PathVariable(value="cardNo") String cardNo) {
        VisitRegistInfo visitRegistInfo = this.visitRegistInfoService.findByCardNo(cardNo);
        VisitRegistInfoVO vo = (VisitRegistInfoVO)BaseVO.conversion((BaseEntity)visitRegistInfo, VisitRegistInfoVO.class);
        return R.ok((Object)vo);
    }

    @GetMapping
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e", httpMethod="GET")
    public Result<VisitRegistInfoVO> findById(@PathVariable(value="id") Long id) {
        VisitRegistInfo visitRegistInfo = (VisitRegistInfo)this.visitRegistInfoService.getById((Serializable)id);
        VisitRegistInfoVO vo = (VisitRegistInfoVO)BaseVO.conversion((BaseEntity)visitRegistInfo, VisitRegistInfoVO.class);
        return R.ok((Object)vo);
    }

    @PostMapping
    public Result insert(@RequestBody @Validated(value={Insert.class}) VisitRegistInfoExtend visitRegistInfo) {
        boolean result;
        Resp resp;
        MySession session = (MySession)this.request.getAttribute("Access-Token");
        VisitRegistInfo info = this.visitRegistInfoService.findByUserId(session.getUserId());
        if (ObjectUtils.isNotEmpty((Object)info)) {
            return R.ok((Object)info);
        }
        info = this.visitRegistInfoService.findByMobile(visitRegistInfo.getMobile());
        if (ObjectUtils.isNotEmpty((Object)info)) {
            this.conversion(visitRegistInfo, info);
            info.setUserId(Integer.valueOf(session.getUserId()));
            EntityDateUtil.supplementUpdate((BaseEntity)info);
            this.visitRegistInfoService.updateById((Object)info);
        }
        if (WebConstant.IDENTITY_CARD_TYPE.equals(visitRegistInfo.getIdentityCardType()) && !"200".equals((resp = this.identityCardServiceExport.identityCard(visitRegistInfo.getIdentityCard(), visitRegistInfo.getName())).getCode())) {
            return R.failure((String)"5105", (String)resp.getMessage());
        }
        EntityDateUtil.supplementInsert((BaseEntity)visitRegistInfo);
        String ip = IPUtil.getIP((HttpServletRequest)this.request);
        visitRegistInfo.setIp(ip);
        this.refresh((VisitRegistInfo)visitRegistInfo);
        visitRegistInfo.setUserId(Integer.valueOf(session.getUserId()));
        visitRegistInfo.setNumbers(WebConstant.NUMBER);
        String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN);
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            return R.failure();
        }
        visitRegistInfo.setCardNo(cardNo);
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getSpecial()) && visitRegistInfo.getSpecial().booleanValue()) {
            visitRegistInfo.setOrderStatus(WebConstant.WX_PAID);
        }
        if (result = this.visitRegistInfoService.save((Object)visitRegistInfo)) {
            return R.ok((Object)visitRegistInfo);
        }
        return R.failure();
    }

    @PostMapping
    @ApiOperation(value="\u6dfb\u52a0\u540c\u884c\u4eba")
    public Result<VisitRegistInfoExtend> addPartner(@RequestBody VisitRegistInfoExtend visitRegistInfoExtend) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{visitRegistInfoExtend.getMobile(), visitRegistInfoExtend.getName()})) {
            return R.badParameter();
        }
        VisitRegistInfo infoDb = this.visitRegistInfoService.findByMobile(visitRegistInfoExtend.getMobile());
        if (!ObjectUtils.isEmpty((Object)infoDb)) {
            return R.failure((String)"5601");
        }
        EntityDateUtil.supplementInsert((BaseEntity)visitRegistInfoExtend);
        visitRegistInfoExtend.setInviteUserId(MyContext.userId());
        visitRegistInfoExtend.setNumbers(WebConstant.NUMBER);
        this.visitRegistInfoService.save((Object)visitRegistInfoExtend);
        return R.ok((Object)visitRegistInfoExtend);
    }

    @PostMapping
    @ApiOperation(value="\u6dfb\u52a0\u540c\u884c\u4eba-\u6279\u91cf")
    public Result<List<VisitRegistInfo>> batchAddPartner(@RequestBody List<VisitRegistInfo> visitRegistInfos) {
        if (CollectionUtils.isEmpty(visitRegistInfos)) {
            return R.badParameter();
        }
        Integer userId = MyContext.userId();
        List mobiles = visitRegistInfos.stream().map(VisitRegistInfo::getMobile).collect(Collectors.toList());
        List existences = this.visitRegistInfoService.findByMobiles(mobiles);
        List<Object> mobileDbs = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)existences)) {
            mobileDbs = existences.stream().map(VisitRegistInfo::getMobile).collect(Collectors.toList());
        }
        ArrayList finalMobileDbs = mobileDbs;
        List list = visitRegistInfos.stream().filter(f -> !finalMobileDbs.contains(f.getMobile())).peek(v -> {
            v.setInviteUserId(userId);
            v.setNumbers(WebConstant.NUMBER);
            EntityDateUtil.supplementInsert((BaseEntity)v);
        }).collect(Collectors.toList());
        this.visitRegistInfoService.saveBatch(list);
        return R.ok(list);
    }

    @GetMapping
    @ApiOperation(value="\u5220\u9664\u540c\u884c\u4eba")
    public Result<Boolean> deletePartner(@PathVariable(value="id") Integer id) {
        this.visitRegistInfoService.removeById((Serializable)id);
        return R.ok();
    }

    @GetMapping
    @ApiOperation(value="\u67e5\u627e\u6211\u7684\u540c\u884c\u4eba")
    public Result<List<VisitRegistInfo>> findPartner() {
        return R.ok((Object)this.visitRegistInfoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(VisitRegistInfo::getNumbers, (Object)WebConstant.NUMBER)).eq(VisitRegistInfo::getInviteUserId, (Object)MyContext.userId())));
    }

    private void existsCompanyWeChatByPhone(VisitRegistInfo visitRegistInfo) {
        if (visitRegistInfo != null && visitRegistInfo.getIsBindCompanyWechat() != null && !visitRegistInfo.getIsBindCompanyWechat().booleanValue()) {
            CompletableFuture.runAsync(() -> {
                String url = "http://hive-api.iteschina.com/we/customer/existsByPhone?phone=" + visitRegistInfo.getMobile();
                String resultStr = HttpUtil.get((String)url);
                JSONObject object = JSONObject.fromObject((Object)resultStr);
                boolean data = object.getBoolean("data");
                if (data) {
                    this.visitRegistInfoService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(VisitRegistInfo::getMobile, (Object)visitRegistInfo.getMobile())).set(VisitRegistInfo::getIsBindCompanyWechat, (Object)true));
                }
            }, this.registryThreadPool);
        }
    }

    private void conversion(VisitRegistInfoExtend visitRegistInfo, VisitRegistInfo info) {
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getSex())) {
            info.setSex(visitRegistInfo.getSex());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getCompany())) {
            info.setCompany(visitRegistInfo.getCompany());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getDepartment())) {
            info.setDepartment(visitRegistInfo.getDepartment());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getPosition())) {
            info.setPosition(visitRegistInfo.getPosition());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getEmail())) {
            info.setEmail(visitRegistInfo.getEmail());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getQuestion())) {
            info.setQuestion(visitRegistInfo.getQuestion());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getAddress())) {
            info.setAddress(visitRegistInfo.getAddress());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getCountryId())) {
            info.setCountryId(visitRegistInfo.getCountryId());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getCountry())) {
            info.setCountry(visitRegistInfo.getCountry());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getProvinceId())) {
            info.setProvinceId(visitRegistInfo.getProvinceId());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getProvince())) {
            info.setProvince(visitRegistInfo.getProvince());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getCityId())) {
            info.setCityId(visitRegistInfo.getCityId());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getCity())) {
            info.setCity(visitRegistInfo.getCity());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getAreaId())) {
            info.setAreaId(visitRegistInfo.getAreaId());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getArea())) {
            info.setArea(visitRegistInfo.getArea());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getIdentityCardType())) {
            info.setIdentityCardType(visitRegistInfo.getIdentityCardType());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getIdentityCard())) {
            info.setIdentityCard(visitRegistInfo.getIdentityCard());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getName())) {
            info.setName(visitRegistInfo.getName());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getTerminal())) {
            info.setTerminal(visitRegistInfo.getTerminal());
        }
        if (ObjectUtils.isNotEmpty((Object)visitRegistInfo.getIp())) {
            info.setIp(visitRegistInfo.getIp());
        }
    }

    @PostMapping
    @ApiOperation(value="\u81ea\u52a8\u9884\u767b\u8bb0", httpMethod="POST")
    public Result autoRegister(@RequestBody VisitRegistInfoExtend visitRegistInfo) {
        boolean result;
        Resp resp;
        if (StringUtils.isEmpty((CharSequence)visitRegistInfo.getName()) || StringUtils.isEmpty((CharSequence)visitRegistInfo.getCompany()) || StringUtils.isEmpty((CharSequence)visitRegistInfo.getMobile())) {
            return R.failure();
        }
        VisitRegistInfo registInfo = this.visitRegistInfoService.findByMobile(visitRegistInfo.getMobile());
        if (ObjectUtils.isNotEmpty((Object)registInfo)) {
            return R.ok();
        }
        if (WebConstant.IDENTITY_CARD_TYPE.equals(visitRegistInfo.getIdentityCardType()) && !"200".equals((resp = this.identityCardServiceExport.identityCard(visitRegistInfo.getIdentityCard(), visitRegistInfo.getName())).getCode())) {
            return R.failure((String)"5105", (String)resp.getMessage());
        }
        visitRegistInfo.setNumbers(WebConstant.NUMBER);
        EntityDateUtil.supplementInsert((BaseEntity)visitRegistInfo);
        if (StringUtils.isBlank((CharSequence)visitRegistInfo.getCardNo())) {
            String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN);
            if (StringUtils.isBlank((CharSequence)cardNo)) {
                return R.failure();
            }
            visitRegistInfo.setCardNo(cardNo);
        }
        if (!(result = this.visitRegistInfoService.save((Object)visitRegistInfo))) {
            return R.failure();
        }
        this.visitRegistInfoService.sendMailAndMessage((VisitRegistInfo)visitRegistInfo);
        visitRegistInfo.setSync(Boolean.valueOf(false));
        EntityDateUtil.supplementUpdate((BaseEntity)visitRegistInfo);
        if (this.visitRegistInfoService.updateById((Object)visitRegistInfo)) {
            VisitRegistInfoVO vo = (VisitRegistInfoVO)BaseVO.conversion((BaseEntity)visitRegistInfo, VisitRegistInfoVO.class);
            vo.setIsPreSuccess(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)visitRegistInfo.getSmsStatus())));
            return R.ok((Object)vo);
        }
        return R.failure();
    }

    @PutMapping
    public Result update(@RequestBody @Validated(value={Update.class}) VisitRegistInfoExtend visitRegistInfo) {
        Resp resp;
        if (WebConstant.IDENTITY_CARD_TYPE.equals(visitRegistInfo.getIdentityCardType()) && !"200".equals((resp = this.identityCardServiceExport.identityCard(visitRegistInfo.getIdentityCard(), visitRegistInfo.getName())).getCode())) {
            return R.failure((String)"5105", (String)resp.getMessage());
        }
        VisitRegistInfo oldVisitRegistInfo = (VisitRegistInfo)this.visitRegistInfoService.getById((Serializable)visitRegistInfo.getId());
        BeanUtils.copyProperties((Object)visitRegistInfo, (Object)oldVisitRegistInfo, (String[])new String[]{"cardNo", "smsStatus", "smsContent", "smsResult", "expressVisitingCard", "entryMode", "source", "sourceUrl", "preRegistUrl", "exhibitorInviteNo", "exhibitorInviteUser", "exhibitionSource", "visitSource", "inviteUnionid", "inviteUserId", "orderSn", "orderStatus", "createTime", "unionid", "isBindCompanyWechat"});
        if (StringUtils.isBlank((CharSequence)oldVisitRegistInfo.getCardNo())) {
            String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN);
            if (StringUtils.isBlank((CharSequence)cardNo)) {
                return R.failure();
            }
            oldVisitRegistInfo.setCardNo(cardNo);
        }
        EntityDateUtil.supplementUpdate((BaseEntity)oldVisitRegistInfo);
        boolean result = this.visitRegistInfoService.updateById((Object)oldVisitRegistInfo);
        if (oldVisitRegistInfo.getIsBindCompanyWechat().booleanValue()) {
            this.visitRegistInfoService.sendMailAndMessage(oldVisitRegistInfo);
        }
        if (result) {
            return R.ok((Object)visitRegistInfo);
        }
        return R.failure();
    }

    @GetMapping
    public Result delete(@PathVariable(value="id") Long id) {
        return R.ok((Object)this.visitRegistInfoService.removeById((Serializable)id));
    }

    @GetMapping
    public Result deleteInternalRegist(@PathVariable(value="mobile") String mobiles) {
        String[] mobileArray = StringUtils.split((String)mobiles, (String)"-");
        return R.ok((Object)this.visitRegistInfoService.remove(mobileArray));
    }

    @DeleteMapping
    public Result delete(@RequestBody List<Long> ids) {
        return R.ok((Object)this.visitRegistInfoService.removeByIds(ids));
    }

    private void refresh(VisitRegistInfo visitRegistInfo) {
        BasicUser basicUser = (BasicUser)this.basicUserService.getById((Serializable)MyContext.userId());
        BeanUtils.copyProperties((Object)visitRegistInfo, (Object)basicUser, (String[])new String[]{"id"});
        EntityDateUtil.supplementUpdate((BaseEntity)basicUser);
        this.basicUserService.updateById((Object)basicUser);
        MySession session = MyContext.session();
        MySession.refreshSession((MySession)session, (BasicUser)basicUser);
        this.basicUserService.refreshSession(session);
    }

    @GetMapping
    @ApiOperation(value="\u540c\u6b65\u9884\u767b\u8bb0\u81f3\u8702\u5de2", httpMethod="GET")
    public List<VisitRegistInfo> sync() {
        List list = this.visitRegistInfoService.findWaitSync();
        return list;
    }

    @GetMapping
    @ApiOperation(value="\u4fee\u6539\u5df2\u540c\u6b65\u8702\u5de2\u9884\u767b\u8bb0\u6570\u636e\u72b6\u6001", httpMethod="GET")
    public Result ack(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.visitRegistInfoService.updateSync(ids);
        }
        return R.ok();
    }

    @GetMapping
    @ExculdeSecurity
    public Result setItesPre(@PathVariable(value="flag") boolean flag) {
        this.redisManager.set("pre_regist_flag", (Object)flag);
        return R.ok();
    }

    @GetMapping
    @ExculdeSecurity
    public Result itesPre() {
        return R.ok((Object)this.redisManager.get("pre_regist_flag"));
    }
}

