/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.controller;

import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.context.MyContext;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.valid.interfaces.Insert;
import com.ites.web.common.valid.interfaces.Query;
import com.ites.web.common.valid.interfaces.Update;
import com.ites.web.common.vo.BaseVO;
import com.ites.web.email.manager.EmailManager;
import com.ites.web.email.properties.MailProperties;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.visit.entity.VisitRegistInfo;
import com.ites.web.visit.entity.VisitRegistInfoEn;
import com.ites.web.visit.service.VisitRegistInfoEnService;
import com.ites.web.visit.service.VisitRegistNoService;
import com.ites.web.visit.vo.VisitRegistInfoEnVO;
import com.ites.web.visit.vo.VisitRegistInfoVO;
import com.joneying.web.authentication.annotation.ExculdeSecurity;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.handler.annotation.PutMapping;
import com.joneying.web.logger.annotation.CommonController;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d77\u5916\u89c2\u4f17\u767b\u8bb0 API"})
public class VisitRegistInfoEnController
extends BaseController {
    @Resource
    private VisitRegistInfoEnService visitRegistInfoEnService;
    @Resource
    private VisitRegistNoService visitRegistNoService;
    @Resource
    private MailProperties mailProperties;
    @Resource
    private EmailManager emailManager;

    @PostMapping
    @CommonController(description="\u6839\u636e\u90ae\u7bb1\u68c0\u7d22\u767b\u8bb0\u4fe1\u606f")
    @ApiOperation(value="\u6839\u636e\u90ae\u7bb1\u68c0\u7d22\u767b\u8bb0\u4fe1\u606f", httpMethod="POST")
    public Result<VisitRegistInfoEnVO> findByEmail(@RequestBody @Validated(value={Query.class}) VisitRegistInfoEn visitRegistInfo) {
        VisitRegistInfoEn visitRegistInfoEn = this.visitRegistInfoEnService.findByEmail(visitRegistInfo.getEmail());
        if (ObjectUtils.isEmpty((Object)visitRegistInfoEn)) {
            return R.ok();
        }
        VisitRegistInfoEnVO vo = (VisitRegistInfoEnVO)BaseVO.conversion((BaseEntity)visitRegistInfoEn, VisitRegistInfoEnVO.class);
        vo.setRegist(Boolean.valueOf(WebConstant.NUMBER.equals(visitRegistInfoEn.getNumbers())));
        return R.ok((Object)vo);
    }

    @PostMapping
    @CommonController(description="\u65b0\u589e\u767b\u8bb0\u4fe1\u606f")
    @ApiOperation(value="\u65b0\u589e\u767b\u8bb0\u4fe1\u606f", httpMethod="POST")
    public Result<?> insert(@RequestBody VisitRegistInfoEn visitRegistInfoEn) {
        VisitRegistInfoEn registerInfoEn = this.visitRegistInfoEnService.findByEmail(visitRegistInfoEn.getEmail());
        if (ObjectUtils.isNotEmpty((Object)registerInfoEn)) {
            return R.ok();
        }
        this.visitRegistInfoEnService.saveVisitRegisterInfoEn(visitRegistInfoEn, this.request);
        this.emailManager.sendVisitRegisterEmailEn(visitRegistInfoEn);
        return R.ok((Object)visitRegistInfoEn.getId());
    }

    @PostMapping
    @ApiOperation(value="\u6dfb\u52a0\u540c\u884c\u4eba")
    public Result<Boolean> batchAddPartner(@RequestBody List<VisitRegistInfoEn> visitRegisterInfoEns) {
        this.visitRegistInfoEnService.batchAddPartner(visitRegisterInfoEns, this.request);
        return R.ok((Object)true);
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539\u6570\u636e", httpMethod="PUT")
    public Result update(@RequestBody @Validated(value={Update.class}) VisitRegistInfoEn visitRegistInfoEn) {
        EntityDateUtil.supplementUpdate((BaseEntity)visitRegistInfoEn);
        return R.ok((Object)this.visitRegistInfoEnService.updateById((Object)visitRegistInfoEn));
    }

    @PostMapping
    @CommonController(description="\u63d0\u4ea4\u95ee\u5377\u4fe1\u606f")
    @ApiOperation(value="\u63d0\u4ea4\u95ee\u5377\u4fe1\u606f", httpMethod="POST")
    public Result<VisitRegistInfoVO> submitQuestion(@RequestBody @Validated(value={Update.class}) VisitRegistInfo visitRegist) {
        VisitRegistInfoEn visitRegistDB = (VisitRegistInfoEn)this.visitRegistInfoEnService.getById((Serializable)visitRegist.getId());
        visitRegistDB.setQuestion(visitRegist.getQuestion());
        EntityDateUtil.supplementUpdate((BaseEntity)visitRegist);
        this.visitRegistInfoEnService.updateById((Object)visitRegistDB);
        VisitRegistInfoVO vo = (VisitRegistInfoVO)BaseVO.conversion((BaseEntity)visitRegistDB, VisitRegistInfoVO.class);
        return R.ok((Object)vo);
    }

    @PostMapping
    @CommonController(description="\u6dfb\u52a0\u540c\u884c\u4eba")
    @ApiOperation(value="\u6dfb\u52a0\u540c\u884c\u4eba", httpMethod="POST")
    public Result<?> addPartner(@RequestBody @Validated(value={Insert.class}) VisitRegistInfoEn visitRegistInfoEn) {
        VisitRegistInfoEn visit = this.visitRegistInfoEnService.findByEmail(visitRegistInfoEn.getEmail());
        if (ObjectUtils.isNotEmpty((Object)visit)) {
            return R.failure((String)"5102");
        }
        visitRegistInfoEn.setInviteUserId(MyContext.userId());
        this.visitRegistInfoEnService.saveVisitRegisterInfoEn(visitRegistInfoEn, this.request);
        this.emailManager.sendVisitRegisterEmailEn(visitRegistInfoEn);
        return R.ok();
    }

    @GetMapping
    @CommonController(description="\u8702\u5de2\u540c\u6b65\u9884\u767b\u8bb0\u6570\u636e")
    @ApiOperation(value="\u8702\u5de2\u540c\u6b65\u9884\u767b\u8bb0\u6570\u636e", httpMethod="GET")
    @ExculdeSecurity
    public Result sync() {
        List list = this.visitRegistInfoEnService.findWaitSync();
        return R.ok((Object)list);
    }

    @GetMapping
    @CommonController(description="\u4fee\u6539\u540c\u6b65\u9884\u767b\u8bb0\u6570\u636e\u72b6\u6001")
    @ApiOperation(value="\u4fee\u6539\u540c\u6b65\u9884\u767b\u8bb0\u6570\u636e\u72b6\u6001", httpMethod="GET")
    @ExculdeSecurity
    public Result ack(String cardNo) {
        if (ObjectUtils.isNotEmpty((Object)cardNo)) {
            this.visitRegistInfoEnService.updateSync(cardNo);
        }
        return R.ok();
    }
}

