/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.controller;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.valid.interfaces.Insert;
import com.ites.web.utils.ExcelUtil;
import com.ites.web.utils.ValidateUtil;
import com.ites.web.visit.entity.WebVisitGroup;
import com.ites.web.visit.entity.WebVisitGroupUser;
import com.ites.web.visit.service.VisitRegistNoService;
import com.ites.web.visit.service.WebVisitGroupService;
import com.ites.web.visit.service.WebVisitGroupUserService;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.logger.annotation.CommonController;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import com.simm.common.utils.StringUtil;
import com.simm.publicservice.export.IdentityCardServiceExport;
import com.simm.publicservice.pojo.Resp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u5bfc\u5165\u56e2\u4f53\u89c2\u4f17"})
public class WebVisitGroupUserExcelController
extends BaseController {
    @Autowired
    private WebVisitGroupUserService webVisitGroupUserService;
    @Autowired
    private VisitRegistNoService visitRegistNoService;
    @Autowired
    private WebVisitGroupService webVisitGroupService;
    @Reference
    private IdentityCardServiceExport identityCardServiceExport;

    @GetMapping
    @ApiOperation(value="\u4e0b\u8f7dexcel\u5bfc\u5165\u6a21\u677f", httpMethod="GET", notes="\u4e0b\u8f7dexcel\u5bfc\u5165\u6a21\u677f")
    public Result downloadTemplateExhibitorBaseInfo() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("static/excel/\u56e2\u4f53\u89c2\u4f17\u9884\u767b\u8bb0\u6a21\u677f.xlsx");
        this.response.setContentType("application/json");
        try {
            ServletOutputStream out = this.response.getOutputStream();
            String fileName = "\u56e2\u4f53\u89c2\u4f17\u9884\u767b\u8bb0\u6a21\u677f.xlsx";
            this.response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("UTF-8"), "iso-8859-1"));
            int b = 0;
            byte[] buffer = new byte[1000000];
            while (b != -1) {
                b = inputStream.read(buffer);
                if (b == -1) continue;
                out.write(buffer, 0, b);
            }
            inputStream.close();
            out.close();
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return R.ok();
    }

    @PostMapping
    @ApiOperation(value="\u5bfc\u5165excel", httpMethod="POST", notes="\u5bfc\u5165excel")
    public Result importExhibitorBaseInfo(@ApiParam(required=true, value="\u4e0a\u4f20\u6587\u4ef6") MultipartFile file, Integer groupId) {
        if (groupId == null) {
            return R.failure();
        }
        WebVisitGroup visitGroup = (WebVisitGroup)this.webVisitGroupService.getById((Serializable)groupId);
        ArrayList<WebVisitGroupUser> notImportData = new ArrayList<WebVisitGroupUser>();
        try {
            Workbook workbook = ExcelUtil.getWorkbook((MultipartFile)file);
            Sheet sheet = workbook.getSheetAt(0);
            if (sheet == null) {
                return R.failure((String)"500", (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0e\u4e0b\u8f7d\u6a21\u677f\u4e0d\u5339\u914d");
            }
            int rowNum = sheet.getLastRowNum();
            for (int i = 1; i <= rowNum; ++i) {
                WebVisitGroupUser visitGroupUser;
                Row currentRow = sheet.getRow(i);
                if (null == currentRow || ExcelUtil.isRowEmpty((Row)currentRow)) continue;
                WebVisitGroupUser webVisitGroupUser = new WebVisitGroupUser();
                this.buildWebVisitGroupUser(webVisitGroupUser, currentRow);
                StringBuilder sb = new StringBuilder();
                if (StringUtils.isBlank((CharSequence)webVisitGroupUser.getCompany())) {
                    sb.append("\u4f01\u4e1a\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
                }
                if (StringUtils.isBlank((CharSequence)webVisitGroupUser.getName())) {
                    sb.append("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
                }
                if (StringUtils.isBlank((CharSequence)webVisitGroupUser.getDepartment())) {
                    sb.append("\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
                }
                if (StringUtils.isBlank((CharSequence)webVisitGroupUser.getPosition())) {
                    sb.append("\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
                }
                if (StringUtils.isBlank((CharSequence)webVisitGroupUser.getMobile())) {
                    sb.append("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
                }
                if (!ValidateUtil.isTelphone((String)webVisitGroupUser.getMobile())) {
                    sb.append("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                }
                if ((visitGroupUser = this.webVisitGroupUserService.findByMobile(webVisitGroupUser.getMobile())) != null) {
                    sb.append("\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728\uff0c");
                }
                if (StringUtils.isBlank((CharSequence)webVisitGroupUser.getEmail())) {
                    sb.append("\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a\uff0c");
                } else if (!ValidateUtil.isEmail((String)webVisitGroupUser.getEmail())) {
                    sb.append("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c");
                }
                if (StringUtil.isBlank((String)webVisitGroupUser.getIdentityCard())) {
                    sb.append("\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    Resp resp = this.identityCardServiceExport.identityCard(webVisitGroupUser.getIdentityCard(), webVisitGroupUser.getName());
                    if (!"200".equals(resp.getCode())) {
                        sb.append("\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u6b63\u786e");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    webVisitGroupUser.setRemark(sb.toString());
                    notImportData.add(webVisitGroupUser);
                    continue;
                }
                webVisitGroupUser.setGroupId(groupId);
                webVisitGroupUser.setNumber(WebConstant.NUMBER);
                String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN_TEAM);
                webVisitGroupUser.setCardNo(cardNo);
                webVisitGroupUser.setCountryId(visitGroup.getCountryId());
                webVisitGroupUser.setCountryName(visitGroup.getCountryName());
                webVisitGroupUser.setProvinceId(visitGroup.getProvinceId());
                webVisitGroupUser.setProvinceName(visitGroup.getProvinceName());
                webVisitGroupUser.setCountryId(visitGroup.getCityId());
                webVisitGroupUser.setCityName(visitGroup.getCityName());
                webVisitGroupUser.setAreaId(visitGroup.getAreaId());
                webVisitGroupUser.setAreaName(visitGroup.getAreaName());
                this.webVisitGroupUserService.save((Object)webVisitGroupUser);
            }
            if (CollectionUtils.isEmpty(notImportData)) {
                return R.ok();
            }
            return R.ok(notImportData);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.info((Object)e);
            return R.failure((String)"5204");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info((Object)e);
            return R.failure((String)"5204");
        }
    }

    @PostMapping
    @CommonController(description="Excel\u4fdd\u5b58\u56e2\u4f53\u89c2\u4f17\u4fe1\u606f")
    @ApiOperation(value="Excel\u4fdd\u5b58\u56e2\u4f53\u89c2\u4f17\u4fe1\u606f", httpMethod="POST")
    public Result saveGroupUser(@RequestBody @Validated(value={Insert.class}) WebVisitGroupUser webVisitGroupUser) {
        WebVisitGroup visitGroup = (WebVisitGroup)this.webVisitGroupService.getById((Serializable)webVisitGroupUser.getGroupId());
        WebVisitGroupUser visitGroupUser = this.webVisitGroupUserService.findByMobile(webVisitGroupUser.getMobile());
        if (ObjectUtils.isNotEmpty((Object)visitGroupUser)) {
            return R.failure((String)"5202");
        }
        webVisitGroupUser.setNumber(WebConstant.NUMBER);
        String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN_TEAM);
        webVisitGroupUser.setCardNo(cardNo);
        webVisitGroupUser.setCountryId(visitGroup.getCountryId());
        webVisitGroupUser.setCountryName(visitGroup.getCountryName());
        webVisitGroupUser.setProvinceId(visitGroup.getProvinceId());
        webVisitGroupUser.setProvinceName(visitGroup.getProvinceName());
        webVisitGroupUser.setCityId(visitGroup.getCityId());
        webVisitGroupUser.setCityName(visitGroup.getCityName());
        webVisitGroupUser.setAreaId(visitGroup.getAreaId());
        webVisitGroupUser.setAreaName(visitGroup.getAreaName());
        this.webVisitGroupUserService.save((Object)webVisitGroupUser);
        return R.ok((Object)webVisitGroupUser.getGroupId());
    }

    @PostMapping
    @CommonController(description="Excel\u4fdd\u5b58\u56e2\u4f53\u89c2\u4f17\u4fe1\u606f")
    @ApiOperation(value="Excel\u4fdd\u5b58\u56e2\u4f53\u89c2\u4f17\u4fe1\u606f", httpMethod="POST")
    public Result batchSaveGroupUser(@RequestBody @Validated(value={Insert.class}) List<WebVisitGroupUser> list) {
        ArrayList<WebVisitGroupUser> users = new ArrayList<WebVisitGroupUser>();
        for (WebVisitGroupUser webVisitGroupUser : list) {
            String mobile = webVisitGroupUser.getMobile();
            if (ObjectUtils.isEmpty((Object)mobile)) {
                return R.badParameter();
            }
            WebVisitGroup visitGroup = (WebVisitGroup)this.webVisitGroupService.getById((Serializable)webVisitGroupUser.getGroupId());
            WebVisitGroupUser visitGroupUser = this.webVisitGroupUserService.findByMobile(mobile);
            if (visitGroupUser != null) {
                return R.failure((String)"5202");
            }
            webVisitGroupUser.setNumber(WebConstant.NUMBER);
            String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN_TEAM);
            webVisitGroupUser.setCardNo(cardNo);
            webVisitGroupUser.setCountryId(visitGroup.getCountryId());
            webVisitGroupUser.setCountryName(visitGroup.getCountryName());
            webVisitGroupUser.setProvinceId(visitGroup.getProvinceId());
            webVisitGroupUser.setProvinceName(visitGroup.getProvinceName());
            webVisitGroupUser.setCityId(visitGroup.getCityId());
            webVisitGroupUser.setCityName(visitGroup.getCityName());
            webVisitGroupUser.setAreaId(visitGroup.getAreaId());
            webVisitGroupUser.setAreaName(visitGroup.getAreaName());
            users.add(webVisitGroupUser);
        }
        this.webVisitGroupUserService.saveBatch(users);
        return R.ok();
    }

    private void buildWebVisitGroupUser(WebVisitGroupUser webVisitGroupUser, Row row) {
        int cellCount = 7;
        block9: for (int currCell = 0; currCell < cellCount; ++currCell) {
            Cell cell = row.getCell(currCell);
            if (cell != null && currCell == 4) {
                cell.setCellType(1);
            }
            String value = ExcelUtil.getStringCellValue((Cell)cell);
            switch (currCell) {
                case 0: {
                    webVisitGroupUser.setCompany(value);
                    continue block9;
                }
                case 1: {
                    webVisitGroupUser.setName(value);
                    continue block9;
                }
                case 2: {
                    webVisitGroupUser.setDepartment(value);
                    continue block9;
                }
                case 3: {
                    webVisitGroupUser.setPosition(value);
                    continue block9;
                }
                case 4: {
                    webVisitGroupUser.setMobile(value);
                    continue block9;
                }
                case 5: {
                    webVisitGroupUser.setEmail(value);
                    continue block9;
                }
                case 6: {
                    webVisitGroupUser.setIdentityCard(value);
                    continue block9;
                }
            }
        }
    }
}

