/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.context.MyContext;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.handler.ServiceException;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.utils.IPUtil;
import com.ites.web.utils.TerminalUtil;
import com.ites.web.visit.dao.VisitRegistInfoEnDao;
import com.ites.web.visit.entity.VisitRegistInfoEn;
import com.ites.web.visit.service.VisitRegistInfoEnService;
import com.ites.web.visit.service.VisitRegistNoService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="visitRegistInfoEnService")
public class VisitRegistInfoEnServiceImpl
extends ServiceImpl<VisitRegistInfoEnDao, VisitRegistInfoEn>
implements VisitRegistInfoEnService {
    private final VisitRegistNoService visitRegistNoService;

    public VisitRegistInfoEn findByEmail(String email) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(VisitRegistInfoEn::getEmail, (Object)email);
        queryWrapper.orderByDesc(VisitRegistInfoEn::getCreateTime);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (VisitRegistInfoEn)list.get(0);
    }

    public List<VisitRegistInfoEn> findWaitSync() {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(VisitRegistInfoEn::getSync, (Object)false)).eq(VisitRegistInfoEn::getNumbers, (Object)WebConstant.NUMBER);
        return this.list((Wrapper)queryWrapper);
    }

    public void updateSync(String cardNos) {
        List list = Arrays.asList(cardNos.split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().in(VisitRegistInfoEn::getCardNo, list);
        VisitRegistInfoEn info = new VisitRegistInfoEn();
        info.setSync(Boolean.valueOf(true));
        EntityDateUtil.supplementUpdate((BaseEntity)info);
        this.update((Object)info, (Wrapper)updateWrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchAddPartner(List<VisitRegistInfoEn> visitRegisterInfoEns, HttpServletRequest request) {
        List emailList = visitRegisterInfoEns.stream().map(VisitRegistInfoEn::getEmail).collect(Collectors.toList());
        List existsList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(VisitRegistInfoEn::getEmail, emailList)).list();
        List existsEmailList = existsList.stream().map(VisitRegistInfoEn::getEmail).collect(Collectors.toList());
        visitRegisterInfoEns.removeIf(visitRegisterInfoEn -> existsEmailList.contains(visitRegisterInfoEn.getEmail()));
        for (VisitRegistInfoEn visitRegisterInfoEn2 : visitRegisterInfoEns) {
            visitRegisterInfoEn2.setInviteUserId(MyContext.userId());
            this.saveVisitRegisterInfoEn(visitRegisterInfoEn2, request);
        }
    }

    public void saveVisitRegisterInfoEn(VisitRegistInfoEn visitRegistInfoEn, HttpServletRequest request) {
        String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_EN);
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            throw new ServiceException("5101");
        }
        EntityDateUtil.supplementInsert((BaseEntity)visitRegistInfoEn);
        visitRegistInfoEn.setNumbers(WebConstant.NUMBER);
        visitRegistInfoEn.setIp(IPUtil.getIP((HttpServletRequest)request));
        visitRegistInfoEn.setCardNo(cardNo);
        visitRegistInfoEn.setTerminal(TerminalUtil.termainal((String)request.getHeader("User-Agent")));
        this.save((Object)visitRegistInfoEn);
    }

    public VisitRegistInfoEnServiceImpl(VisitRegistNoService visitRegistNoService) {
        this.visitRegistNoService = visitRegistNoService;
    }
}

