/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.service.impl;

import com.alibaba.dubbo.config.annotation.Reference;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ites.web.basic.entity.BasicUser;
import com.ites.web.basic.service.BasicUserService;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.context.MyContext;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.email.manager.EmailManager;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.visit.dao.VisitRegistInfoDao;
import com.ites.web.visit.entity.VisitRegistInfo;
import com.ites.web.visit.service.VisitRegistInfoService;
import com.ites.web.wx.message.WxTemplateManager;
import com.simm.publicservice.export.SmsServiceExport;
import com.simm.publicservice.pojo.Resp;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="visitRegistInfoService")
public class VisitRegistInfoServiceImpl
extends ServiceImpl<VisitRegistInfoDao, VisitRegistInfo>
implements VisitRegistInfoService {
    @Resource
    private EmailManager emailManager;
    @Resource
    private WxTemplateManager wxTemplateManager;
    @Resource
    private BasicUserService basicUserService;
    @Reference
    private SmsServiceExport smsServiceExport;
    @Resource
    private VisitRegistInfoDao visitRegistInfoDao;

    public VisitRegistInfo findByUserId(int userId) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(VisitRegistInfo::getUserId, (Object)userId)).eq(VisitRegistInfo::getNumbers, (Object)WebConstant.NUMBER));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (VisitRegistInfo)list.get(0);
        }
        return null;
    }

    public VisitRegistInfo findByMobile(String mobile) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(VisitRegistInfo::getMobile, (Object)mobile)).eq(VisitRegistInfo::getNumbers, (Object)WebConstant.NUMBER));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (VisitRegistInfo)list.get(0);
        }
        return null;
    }

    public VisitRegistInfo findByCardNo(String cardNo) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(VisitRegistInfo::getCardNo, (Object)cardNo)).eq(VisitRegistInfo::getNumbers, (Object)WebConstant.NUMBER);
        List list = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (VisitRegistInfo)list.get(0);
        }
        return null;
    }

    public List<VisitRegistInfo> findWaitSync() {
        Page page = new Page(1L, 500L);
        return this.visitRegistInfoDao.findWaitSync(page, WebConstant.NUMBER);
    }

    public void updateSync(String ids) {
        List list = Arrays.asList(ids.split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().in(VisitRegistInfo::getId, list);
        VisitRegistInfo info = new VisitRegistInfo();
        info.setSync(Boolean.valueOf(true));
        EntityDateUtil.supplementUpdate((BaseEntity)info);
        this.update((Object)info, (Wrapper)updateWrapper);
    }

    public void sendMailAndMessage(VisitRegistInfo visitRegistInfo) {
        String code = "200";
        String content = "\u5c0a\u656c\u7684" + visitRegistInfo.getName() + "\uff0c\u60a8\u5df2\u6210\u529f\u767b\u8bb0ITES\u6df1\u5733\u5de5\u4e1a\u5c55\uff01\u8bf7\u4e8e3\u670829\u65e5-4\u67081\u65e5\uff0c\u51ed\u767b\u8bb0\u786e\u8ba4\u4e8c\u7ef4\u7801\u3001\u8eab\u4efd\u8bc1\u5230\u6df1\u5733\u56fd\u9645\u4f1a\u5c55\u4e2d\u5fc3\uff08\u5b9d\u5b89\u65b0\u9986\uff09\u6838\u9a8c\u5165\u573a\u3002\u3010ITES\u6df1\u5733\u5de5\u4e1a\u5c55\u3011";
        Resp resp = this.smsServiceExport.sendCode(visitRegistInfo.getMobile(), content);
        visitRegistInfo.setSmsContent(content);
        visitRegistInfo.setSmsResult(resp.getCode());
        if (!ObjectUtils.isEmpty((Object)resp) && resp.getCode().equals(code)) {
            visitRegistInfo.setSmsStatus("SMSOK");
        } else {
            visitRegistInfo.setSmsStatus("FNULL");
        }
        this.updateById((Object)visitRegistInfo);
        this.emailManager.sendVisitRegisterEmail(visitRegistInfo);
        BasicUser basicUser = (BasicUser)this.basicUserService.getById((Serializable)visitRegistInfo.getUserId());
        if (basicUser != null && StringUtils.isNotBlank((CharSequence)basicUser.getOpenId())) {
            this.wxTemplateManager.sendVisitRegistMessage(basicUser.getOpenId());
        }
    }

    public VisitRegistInfo findByOrderSn(String orderSn) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(VisitRegistInfo::getOrderSn, (Object)orderSn)).eq(VisitRegistInfo::getNumbers, (Object)WebConstant.NUMBER);
        return (VisitRegistInfo)this.getOne((Wrapper)queryWrapper);
    }

    public List<VisitRegistInfo> getPrintInfo() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.ne(VisitRegistInfo::getSupplierSync, (Object)1);
        wrapper.isNotNull(VisitRegistInfo::getIdentityCard);
        wrapper.eq(VisitRegistInfo::getNumbers, (Object)WebConstant.NUMBER);
        Page page = (Page)this.page((IPage)new Page(1L, 1000L), (Wrapper)wrapper);
        return page.getRecords();
    }

    public boolean batchUpdateSyncFlag(List<String> numbers) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(VisitRegistInfo::getSupplierSync, (Object)1);
        wrapper.in(VisitRegistInfo::getCardNo, numbers);
        return this.update((Wrapper)wrapper);
    }

    public VisitRegistInfo findBySession() {
        LambdaQueryWrapper queryWrapperUserId = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(VisitRegistInfo::getNumbers, (Object)WebConstant.NUMBER)).eq(VisitRegistInfo::getUserId, (Object)MyContext.userId());
        List list = this.list((Wrapper)queryWrapperUserId);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (VisitRegistInfo)list.get(0);
        }
        LambdaQueryWrapper queryWrapperMobile = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(VisitRegistInfo::getNumbers, (Object)WebConstant.NUMBER)).eq(VisitRegistInfo::getMobile, (Object)MyContext.session().getMobile());
        list = this.list((Wrapper)queryWrapperMobile);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (VisitRegistInfo)list.get(0);
        }
        return null;
    }

    public Boolean remove(String[] mobiles) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(VisitRegistInfo::getMobile, (Object[])mobiles);
        return this.remove((Wrapper)queryWrapper);
    }

    public Boolean addPartner(List<VisitRegistInfo> partnerList) {
        List mobileList = partnerList.stream().map(VisitRegistInfo::getMobile).collect(Collectors.toList());
        List registerInfoList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(VisitRegistInfo::getMobile, mobileList)).list();
        if (mobileList.size() == registerInfoList.size()) {
            return Boolean.TRUE;
        }
        Map<String, List<VisitRegistInfo>> map = registerInfoList.stream().collect(Collectors.groupingBy(VisitRegistInfo::getMobile));
        for (VisitRegistInfo visitRegistInfo : partnerList) {
            List<VisitRegistInfo> visitRegisterInfos = map.get(visitRegistInfo.getMobile());
            if (!CollectionUtils.isEmpty(visitRegisterInfos)) continue;
            visitRegistInfo.setNumbers(WebConstant.NUMBER);
            this.save((Object)visitRegistInfo);
        }
        return Boolean.TRUE;
    }

    public List<VisitRegistInfo> findByMobiles(List<String> mobiles) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(VisitRegistInfo::getNumbers, (Object)WebConstant.NUMBER)).in(VisitRegistInfo::getMobile, mobiles);
        return this.visitRegistInfoDao.selectList((Wrapper)queryWrapper);
    }
}

