/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.visit.dao.WebVisitGroupDao;
import com.ites.web.visit.dto.VisitGroupDTO;
import com.ites.web.visit.entity.WebVisitGroup;
import com.ites.web.visit.entity.WebVisitGroupUser;
import com.ites.web.visit.service.WebVisitGroupService;
import com.ites.web.visit.service.WebVisitGroupUserService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="webVisitGroupService")
public class WebVisitGroupServiceImpl
extends ServiceImpl<WebVisitGroupDao, WebVisitGroup>
implements WebVisitGroupService {
    private final WebVisitGroupUserService visitGroupUserService;

    public WebVisitGroup findByName(String name) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebVisitGroup::getName, (Object)name)).eq(WebVisitGroup::getNumber, (Object)WebConstant.NUMBER);
        return (WebVisitGroup)this.getOne((Wrapper)queryWrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer saveGroup(VisitGroupDTO visitGroupDTO) {
        WebVisitGroup visitGroup = new WebVisitGroup();
        BeanUtils.copyProperties((Object)visitGroupDTO, (Object)visitGroup);
        visitGroup.setNumber(WebConstant.NUMBER);
        visitGroup.setName(visitGroupDTO.getCompany());
        this.save((Object)visitGroup);
        WebVisitGroupUser visitGroupUser = new WebVisitGroupUser();
        BeanUtils.copyProperties((Object)visitGroupDTO, (Object)visitGroupUser);
        visitGroupUser.setMaster(Boolean.valueOf(true));
        visitGroupUser.setGroupId(visitGroup.getId());
        visitGroupUser.setNumber(WebConstant.NUMBER);
        this.visitGroupUserService.saveGroupUser(visitGroupUser);
        return visitGroup.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer updateGroup(VisitGroupDTO visitGroupDTO) {
        WebVisitGroup visitGroup = new WebVisitGroup();
        BeanUtils.copyProperties((Object)visitGroupDTO, (Object)visitGroup);
        this.updateById((Object)visitGroup);
        WebVisitGroupUser visitMasterUser = this.visitGroupUserService.findMasterUser(visitGroup.getId());
        Integer masterUserId = visitMasterUser.getId();
        BeanUtils.copyProperties((Object)visitGroupDTO, (Object)visitMasterUser);
        visitMasterUser.setId(masterUserId);
        visitMasterUser.setMaster(Boolean.valueOf(true));
        this.visitGroupUserService.updateById((Object)visitMasterUser);
        return visitGroup.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void importFromHive(JSONObject object) {
        WebVisitGroup webVisitGroup = (WebVisitGroup)object.getObject("visitGroup", WebVisitGroup.class);
        this.save((Object)webVisitGroup);
        JSONArray jsonArray = object.getJSONArray("visitGroupUserList");
        jsonArray.forEach(obj -> {
            JSONObject user = JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
            WebVisitGroupUser webVisitGroupUser = new WebVisitGroupUser();
            webVisitGroupUser.setNumber(WebConstant.NUMBER);
            webVisitGroupUser.setMaster(user.getBoolean("isMaster"));
            webVisitGroupUser.setCardNo(user.getString("cardNo"));
            webVisitGroupUser.setAreaId(webVisitGroup.getAreaId());
            webVisitGroupUser.setAreaName(webVisitGroup.getAreaName());
            webVisitGroupUser.setProvinceName(webVisitGroup.getProvinceName());
            webVisitGroupUser.setProvinceId(webVisitGroup.getProvinceId());
            webVisitGroupUser.setCountryName(webVisitGroup.getCountryName());
            webVisitGroupUser.setCountryId(webVisitGroup.getCountryId());
            webVisitGroupUser.setCityId(webVisitGroup.getCityId());
            webVisitGroupUser.setCityName(webVisitGroup.getCityName());
            webVisitGroupUser.setCompany(webVisitGroup.getName());
            webVisitGroupUser.setSex(Integer.valueOf(1));
            webVisitGroupUser.setPosition(user.getString("position"));
            webVisitGroupUser.setIndustry(user.getString("industry"));
            webVisitGroupUser.setDepartment(user.getString("department"));
            webVisitGroupUser.setName(user.getString("name"));
            webVisitGroupUser.setMobile(user.getString("mobile"));
            webVisitGroupUser.setEmail(user.getString("email"));
            webVisitGroupUser.setIdentityCard(user.getString("identityCard"));
            webVisitGroupUser.setGroupId(webVisitGroup.getId());
            this.visitGroupUserService.saveGroupUser(webVisitGroupUser);
        });
    }

    public WebVisitGroupServiceImpl(WebVisitGroupUserService visitGroupUserService) {
        this.visitGroupUserService = visitGroupUserService;
    }
}

