/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.visit.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.dubbo.config.annotation.Reference;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.common.handler.ServiceException;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.utils.QrcodeUtil;
import com.ites.web.visit.dao.WebVisitGroupDao;
import com.ites.web.visit.dao.WebVisitGroupUserDao;
import com.ites.web.visit.entity.WebVisitGroup;
import com.ites.web.visit.entity.WebVisitGroupUser;
import com.ites.web.visit.service.VisitRegistNoService;
import com.ites.web.visit.service.WebVisitGroupUserService;
import com.simm.common.utils.StringUtil;
import com.simm.publicservice.export.IdentityCardServiceExport;
import com.simm.publicservice.pojo.Resp;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="webVisitGroupUserService")
public class WebVisitGroupUserServiceImpl
extends ServiceImpl<WebVisitGroupUserDao, WebVisitGroupUser>
implements WebVisitGroupUserService {
    private final WebVisitGroupDao webVisitGroupDao;
    private final VisitRegistNoService visitRegistNoService;
    @Reference
    private IdentityCardServiceExport identityCardServiceExport;

    @Transactional(rollbackFor={Exception.class})
    public Integer addUserAndGroup(WebVisitGroupUser visitGroupUser) {
        WebVisitGroup visitGroup = new WebVisitGroup();
        BeanUtils.copyProperties((Object)visitGroupUser, (Object)visitGroup);
        visitGroup.setCityName(visitGroupUser.getCityName());
        visitGroup.setNumber(WebConstant.NUMBER);
        EntityDateUtil.supplementInsert((BaseEntity)visitGroup);
        this.webVisitGroupDao.insert((Object)visitGroup);
        EntityDateUtil.supplementInsert((BaseEntity)visitGroupUser);
        visitGroupUser.setNumber(WebConstant.NUMBER);
        visitGroupUser.setGroupId(visitGroup.getId());
        String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN_TEAM);
        visitGroupUser.setCardNo(cardNo);
        String qrCodeUrl = this.generateQrCode(visitGroupUser.getName(), cardNo);
        visitGroupUser.setQrCodeUrl(qrCodeUrl);
        this.save((Object)visitGroupUser);
        return visitGroup.getId();
    }

    public WebVisitGroupUser findByMobile(String mobile) {
        LambdaQueryWrapper userLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebVisitGroupUser::getMobile, (Object)mobile)).eq(WebVisitGroupUser::getNumber, (Object)WebConstant.NUMBER);
        return (WebVisitGroupUser)this.getOne((Wrapper)userLambdaQueryWrapper);
    }

    public void updateGroupUserMaster(Integer id, Integer groupId) {
        WebVisitGroupUser groupUser = new WebVisitGroupUser();
        groupUser.setMaster(Boolean.valueOf(false));
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(WebVisitGroupUser::getGroupId, (Object)groupId);
        this.update((Object)groupUser, (Wrapper)updateWrapper);
        groupUser.setMaster(Boolean.valueOf(true));
        updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(WebVisitGroupUser::getGroupId, (Object)groupId)).eq(BaseEntity::getId, (Object)id);
        this.update((Object)groupUser, (Wrapper)updateWrapper);
    }

    public List<WebVisitGroupUser> findByGroupId(Integer groupId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebVisitGroupUser::getGroupId, (Object)groupId)).eq(WebVisitGroupUser::getNumber, (Object)WebConstant.NUMBER);
        return this.list((Wrapper)queryWrapper);
    }

    public List<WebVisitGroupUser> findWaitSync() {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WebVisitGroupUser::getSync, (Object)false)).eq(WebVisitGroupUser::getNumber, (Object)WebConstant.NUMBER);
        return this.list((Wrapper)queryWrapper);
    }

    public void updateSync(String ids) {
        List list = Arrays.stream(ids.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().in(BaseEntity::getId, list);
        WebVisitGroupUser info = new WebVisitGroupUser();
        info.setSync(Boolean.valueOf(true));
        EntityDateUtil.supplementUpdate((BaseEntity)info);
        this.update((Object)info, (Wrapper)updateWrapper);
    }

    public WebVisitGroupUser findMasterUser(Integer visitGroupId) {
        return (WebVisitGroupUser)((WebVisitGroupUserDao)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(WebVisitGroupUser::getGroupId, (Object)visitGroupId)).eq(WebVisitGroupUser::getMaster, (Object)true));
    }

    public void exportQrCode(Integer groupId, HttpServletResponse response) {
        List visitGroupUserList = this.findByGroupId(groupId);
        try (ServletOutputStream outputStream = response.getOutputStream();
             CheckedOutputStream checkedOutputStream = new CheckedOutputStream((OutputStream)outputStream, new Adler32());
             ZipOutputStream zipOut = new ZipOutputStream(checkedOutputStream);){
            response.setContentType("application/octet-stream");
            String fileName = "\u7535\u5b50\u5165\u573a\u7801.zip";
            response.setHeader("content-disposition", "attachment;filename=" + new String(fileName.getBytes("UTF-8"), "ISO-8859-1"));
            for (WebVisitGroupUser visitGroupUser : visitGroupUserList) {
                if (StringUtil.isBlank((String)visitGroupUser.getQrCodeUrl())) continue;
                byte[] bytes = HttpUtil.downloadBytes((String)visitGroupUser.getQrCodeUrl());
                zipOut.putNextEntry(new ZipEntry(visitGroupUser.getName() + "-" + visitGroupUser.getCardNo() + ".png"));
                zipOut.write(bytes, 0, bytes.length);
                zipOut.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer saveGroupUser(WebVisitGroupUser visitGroupUser) {
        this.checkIdCard(visitGroupUser.getIdentityCard(), visitGroupUser.getName());
        this.checkRepeatRegister(visitGroupUser.getIdentityCard(), visitGroupUser.getMobile());
        String cardNo = this.visitRegistNoService.generator(WebConstant.VISIT_TYPE_CN_TEAM);
        visitGroupUser.setCardNo(cardNo);
        String qrCodeUrl = this.generateQrCode(visitGroupUser.getName(), cardNo);
        visitGroupUser.setQrCodeUrl(qrCodeUrl);
        visitGroupUser.setNumber(WebConstant.NUMBER);
        this.save((Object)visitGroupUser);
        return visitGroupUser.getId();
    }

    private String generateQrCode(String name, String cardNo) {
        return QrcodeUtil.createQRCode((String)cardNo, (String)name, (int)400, (int)400, (String)"ch");
    }

    private void checkRepeatRegister(String identityCard, String mobile) {
        WebVisitGroupUser user = this.findByIdentityCard(identityCard);
        if (Objects.nonNull(user)) {
            throw new ServiceException("5205");
        }
        WebVisitGroupUser user1 = this.findByMobile(mobile);
        if (Objects.nonNull(user1)) {
            throw new ServiceException("5202");
        }
    }

    public WebVisitGroupUser findByIdentityCard(String identityCard) {
        return (WebVisitGroupUser)((WebVisitGroupUserDao)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(WebVisitGroupUser::getIdentityCard, (Object)identityCard)).eq(WebVisitGroupUser::getNumber, (Object)WebConstant.NUMBER));
    }

    private void checkIdCard(String identityCard, String name) {
        Resp resp = this.identityCardServiceExport.identityCard(identityCard, name);
        if (!"200".equals(resp.getCode())) {
            throw new ServiceException("5105", resp.getMessage());
        }
    }

    public WebVisitGroupUserServiceImpl(WebVisitGroupDao webVisitGroupDao, VisitRegistNoService visitRegistNoService) {
        this.webVisitGroupDao = webVisitGroupDao;
        this.visitRegistNoService = visitRegistNoService;
    }
}

