/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.wx.configuration;

import com.ites.web.wx.properties.WxMpProperties;
import java.util.List;
import java.util.stream.Collectors;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WxMpProperties.class})
public class WxMpConfiguration {
    @Autowired
    private WxMpProperties properties;

    @Bean
    public WxMpService wxMpService() {
        List configs = this.properties.getConfigs();
        if (configs == null) {
            throw new RuntimeException("\u5927\u54e5\uff0c\u62dc\u6258\u5148\u770b\u4e0b\u9879\u76ee\u9996\u9875\u7684\u8bf4\u660e\uff08readme\u6587\u4ef6\uff09\uff0c\u6dfb\u52a0\u4e0b\u76f8\u5173\u914d\u7f6e\uff0c\u6ce8\u610f\u522b\u914d\u9519\u4e86\uff01");
        }
        WxMpServiceImpl service = new WxMpServiceImpl();
        service.setMultiConfigStorages(configs.stream().map(a -> {
            WxMpDefaultConfigImpl configStorage = new WxMpDefaultConfigImpl();
            configStorage.setAppId(a.getAppId());
            configStorage.setSecret(a.getSecret());
            configStorage.setToken(a.getToken());
            configStorage.setAesKey(a.getAesKey());
            return configStorage;
        }).collect(Collectors.toMap(WxMpDefaultConfigImpl::getAppId, a -> a, (o, n) -> o)));
        return service;
    }
}

