/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.wx.configuration;

import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import com.ites.web.wx.properties.WxPayProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={WxPayService.class})
@EnableConfigurationProperties(value={WxPayProperties.class})
public class WxPayConfiguration {
    private WxPayProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public WxPayService wxPayService() {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(StringUtils.trimToNull((String)this.properties.getAppId()));
        payConfig.setMchId(StringUtils.trimToNull((String)this.properties.getMchId()));
        payConfig.setMchKey(StringUtils.trimToNull((String)this.properties.getMchKey()));
        payConfig.setSubAppId(StringUtils.trimToNull((String)this.properties.getSubAppId()));
        payConfig.setSubMchId(StringUtils.trimToNull((String)this.properties.getSubMchId()));
        payConfig.setKeyPath(StringUtils.trimToNull((String)this.properties.getKeyPath()));
        payConfig.setNotifyUrl(this.properties.getNotifyUrl());
        payConfig.setUseSandboxEnv(false);
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        return wxPayService;
    }

    public WxPayConfiguration(WxPayProperties properties) {
        this.properties = properties;
    }
}

