/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.wx.controller;

import com.ites.web.basic.entity.BasicUser;
import com.ites.web.basic.service.BasicUserService;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.valid.interfaces.Insert;
import com.ites.web.wx.annotation.ExculdeWxSecurity;
import com.ites.web.wx.controller.WxController;
import com.ites.web.wx.entity.WxAuthorization;
import com.joneying.web.handler.annotation.GetMapping;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.logger.annotation.CommonController;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.bean.oauth2.WxOAuth2AccessToken;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5fae\u4fe1\u63a5\u53e3"})
public class WxController
extends BaseController {
    @Resource
    private WxMpService wxService;
    @Resource
    private BasicUserService basicUserService;

    @PostMapping
    @ExculdeWxSecurity
    @CommonController(description="\u7ec4\u88c5\u5fae\u4fe1\u6388\u6743\u94fe\u63a5")
    @ApiOperation(value="\u7ec4\u88c5\u5fae\u4fe1\u6388\u6743\u94fe\u63a5", notes="\u7ec4\u88c5\u5fae\u4fe1\u6388\u6743\u94fe\u63a5")
    public Result<String> buildAuthorizationURL(@RequestBody @Validated(value={Insert.class}) WxAuthorization authorization) {
        String url = this.wxService.getOAuth2Service().buildAuthorizationUrl(authorization.getRedirectURI(), authorization.getScope(), authorization.getState());
        return R.ok((Object)url);
    }

    @GetMapping
    @ExculdeWxSecurity
    @CommonController(description="\u5fae\u4fe1\u767b\u5f55")
    @ApiOperation(value="\u767b\u5f55", notes="\u767b\u5f55")
    public Result<String> login(@PathVariable(value="code") String code) {
        try {
            WxOAuth2AccessToken accessToken = this.wxService.getOAuth2Service().getAccessToken(code);
            if (ObjectUtils.isEmpty((Object)accessToken) || ObjectUtils.isEmpty((Object)accessToken.getOpenId())) {
                return R.failure();
            }
            this.logger.info("accessToken: {}", (Object)accessToken);
            this.basicUserService.login(accessToken.getOpenId(), accessToken.getUnionId());
            return R.ok((Object)accessToken.getOpenId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.failure();
        }
    }

    @PostMapping
    @ExculdeWxSecurity
    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u7b7e\u540d", notes="\u83b7\u53d6\u5fae\u4fe1\u7b7e\u540d")
    public Result<WxJsapiSignature> getSignature(@RequestBody Signature signature) {
        try {
            this.logger.debug("url=============================>" + signature.getUrl());
            WxJsapiSignature wxJsapiSignature = this.wxService.createJsapiSignature(signature.getUrl());
            return R.ok((Object)wxJsapiSignature);
        }
        catch (WxErrorException e) {
            e.printStackTrace();
            return R.ok();
        }
    }

    @PostMapping
    @ExculdeWxSecurity
    @CommonController(description="\u83b7\u53d6\u516c\u4f17\u53f7\u5ba2\u6237\u5217\u8868")
    @ApiOperation(value="\u83b7\u53d6\u516c\u4f17\u53f7\u5ba2\u6237\u5217\u8868", notes="\u83b7\u53d6\u516c\u4f17\u53f7\u5ba2\u6237\u5217\u8868")
    public void getUserList() {
        String lang = "zh_CN";
        String nextOpenId = null;
        while (true) {
            try {
                block3: while (true) {
                    WxMpUserList userData;
                    if (CollectionUtils.isEmpty((Collection)(userData = this.wxService.getUserService().userList(nextOpenId)).getOpenids())) {
                        return;
                    }
                    nextOpenId = userData.getNextOpenid();
                    Iterator iterator = userData.getOpenids().iterator();
                    block4: while (true) {
                        if (!iterator.hasNext()) continue block3;
                        String openid = (String)iterator.next();
                        System.out.println(openid);
                        WxMpUser wxMpUser = this.wxService.getUserService().userInfo(openid, lang);
                        List list = this.basicUserService.findListByUnionId(wxMpUser.getUnionId());
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                            Iterator iterator2 = list.iterator();
                            while (true) {
                                if (!iterator2.hasNext()) continue block4;
                                BasicUser basicUser = (BasicUser)iterator2.next();
                                basicUser.setSubscribleFlag(wxMpUser.getSubscribe());
                                basicUser.setMpOpenId(openid);
                                basicUser.setUpdateTime(LocalDateTime.now());
                                this.basicUserService.updateById((Object)basicUser);
                            }
                        }
                        LocalDateTime now = LocalDateTime.now();
                        BasicUser newUser = new BasicUser();
                        newUser.setUnionid(wxMpUser.getUnionId());
                        newUser.setMpOpenId(wxMpUser.getOpenId());
                        newUser.setSubscribleFlag(wxMpUser.getSubscribe());
                        newUser.setCreateTime(now);
                        newUser.setRemark("\u83b7\u53d6\u516c\u4f17\u53f7\u5ba2\u6237\u5217\u8868-\u6279\u91cf\u65b0\u589e");
                        this.basicUserService.save((Object)newUser);
                    }
                    break;
                }
            }
            catch (WxErrorException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

