/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.wx.controller;

import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.ites.web.common.constant.WebConstant;
import com.ites.web.common.context.AppContext;
import com.ites.web.common.controller.BaseController;
import com.ites.web.common.entity.BaseEntity;
import com.ites.web.log.entity.WebPayLog;
import com.ites.web.log.service.WebPayLogService;
import com.ites.web.utils.EntityDateUtil;
import com.ites.web.utils.IPUtil;
import com.ites.web.utils.SnUtil;
import com.ites.web.utils.WxPayOrderNotifyResultUtil;
import com.ites.web.visit.entity.VisitRegistInfo;
import com.ites.web.visit.service.VisitRegistInfoService;
import com.joneying.common.annotation.ExculdeSecurity;
import com.joneying.web.handler.annotation.PostMapping;
import com.joneying.web.result.R;
import com.joneying.web.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5fae\u4fe1\u652f\u4ed8\u63a5\u53e3"})
public class WxPayController
extends BaseController {
    @Resource
    private VisitRegistInfoService visitRegistInfoService;
    @Resource
    private WebPayLogService webPayLogService;
    @Resource
    private WxPayService wxPayService;
    @Resource
    private AppContext appContext;

    @PostMapping
    @ApiOperation(value="\u4e0b\u5355", httpMethod="POST")
    public Result<WxPayMpOrderResult> pay(@PathVariable(value="id") Integer id) {
        String orderSn = SnUtil.generate();
        VisitRegistInfo visitRegistInfo = (VisitRegistInfo)this.visitRegistInfoService.getById((Serializable)id);
        visitRegistInfo.setOrderSn(orderSn);
        visitRegistInfo.setOrderStatus(WebConstant.WX_UNPAID);
        this.visitRegistInfoService.updateById((Object)visitRegistInfo);
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();
        String token = this.request.getHeader("Access-Token");
        wxPayUnifiedOrderRequest.setOpenid(this.appContext.session(token).getOpenId());
        wxPayUnifiedOrderRequest.setBody("\u6df1\u5733\u5de5\u4e1a\u5c55\u95e8\u7968");
        wxPayUnifiedOrderRequest.setOutTradeNo(orderSn);
        wxPayUnifiedOrderRequest.setProductId(visitRegistInfo.getId().toString());
        wxPayUnifiedOrderRequest.setTotalFee(Integer.valueOf(5000));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(IPUtil.getIP((HttpServletRequest)this.request));
        wxPayUnifiedOrderRequest.setNotifyUrl(this.wxPayService.getConfig().getNotifyUrl());
        wxPayUnifiedOrderRequest.setTradeType("JSAPI");
        try {
            WxPayMpOrderResult payResult = (WxPayMpOrderResult)this.wxPayService.createOrder(wxPayUnifiedOrderRequest);
            return R.ok((Object)payResult);
        }
        catch (WxPayException e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            e.printStackTrace();
            return R.failure();
        }
    }

    @PostMapping
    @ExculdeSecurity
    @ApiOperation(value="\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u5904\u7406", httpMethod="POST")
    public String parseOrderNotifyResult(@RequestBody String xmlData) throws WxPayException {
        WxPayOrderNotifyResult notifyResult = WxPayOrderNotifyResultUtil.parseOrderNotifyResult((String)xmlData);
        if (ObjectUtils.isEmpty((Object)notifyResult) || !StringUtils.equals((CharSequence)"success", (CharSequence)notifyResult.getReturnCode().toLowerCase())) {
            return null;
        }
        VisitRegistInfo visitRegistInfo = this.visitRegistInfoService.findByOrderSn(notifyResult.getOutTradeNo());
        if (ObjectUtils.nullSafeEquals((Object)visitRegistInfo.getOrderStatus(), (Object)WebConstant.WX_UNPAID)) {
            EntityDateUtil.supplementUpdate((BaseEntity)visitRegistInfo);
            visitRegistInfo.setOrderStatus(WebConstant.WX_PAID);
            this.visitRegistInfoService.updateById((Object)visitRegistInfo);
            this.visitRegistInfoService.sendMailAndMessage(visitRegistInfo);
            WebPayLog log = new WebPayLog();
            log.setTransactionId(notifyResult.getTransactionId());
            log.setOrderSn(notifyResult.getOutTradeNo());
            log.setResult(notifyResult.getReturnCode());
            log.setData(xmlData);
            EntityDateUtil.supplementInsert((BaseEntity)log);
            this.webPayLogService.save((Object)log);
        }
        return WxPayNotifyResponse.success((String)"\u6210\u529f");
    }
}

