/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.wx.handler;

import com.ites.web.wx.builder.ImgBuilder;
import com.ites.web.wx.builder.NewsBuilder;
import com.ites.web.wx.builder.TextBuilder;
import com.ites.web.wx.entity.WebAdminWeixinKeyword;
import com.ites.web.wx.entity.WebAdminWeixinKeywordMessage;
import com.ites.web.wx.service.WebAdminWxKeywordMessageService;
import com.ites.web.wx.service.WebAdminWxKeywordService;
import com.ites.web.wx.util.WechatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutNewsMessage;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.CollectionUtils;

public abstract class AbstractHandler
implements WxMpMessageHandler {
    protected Logger logger = LogManager.getLogger(this.getClass());
    @Resource
    private WebAdminWxKeywordService keywordService;
    @Resource
    private WebAdminWxKeywordMessageService keywordMessageService;

    protected WxMpXmlOutMessage buildMessage(WxMpService wxService, WxMpXmlMessage wxMessage, String keyword) {
        List list = this.keywordService.findListByKeyword(keyword);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        WebAdminWeixinKeyword weixinKeyword = (WebAdminWeixinKeyword)list.get(0);
        List messages = this.keywordMessageService.findList(weixinKeyword.getId());
        if (CollectionUtils.isEmpty((Collection)messages)) {
            return null;
        }
        WebAdminWeixinKeywordMessage message = (WebAdminWeixinKeywordMessage)messages.get(0);
        this.keywordService.addCount(weixinKeyword.getId());
        switch (message.getType()) {
            case 1: {
                return new TextBuilder().build(message.getContent(), wxMessage, wxService);
            }
            case 2: {
                ArrayList<WxMpXmlOutNewsMessage.Item> items = new ArrayList<WxMpXmlOutNewsMessage.Item>();
                for (WebAdminWeixinKeywordMessage m : messages) {
                    WxMpXmlOutNewsMessage.Item item = new WxMpXmlOutNewsMessage.Item();
                    item.setDescription(m.getDescription());
                    item.setPicUrl(m.getImage());
                    item.setTitle(m.getTitle());
                    item.setUrl(m.getUrl());
                    items.add(item);
                }
                return new NewsBuilder().build(items, wxMessage, wxService);
            }
            case 3: {
                try {
                    JSONObject jsonObject = WechatUtil.uploadMeida((String)wxService.getAccessToken(), (String)"image", (String)message.getImage());
                    return new ImgBuilder().build(String.valueOf(jsonObject.get("media_id")), wxMessage, wxService);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new TextBuilder().build("\u6b22\u8fce\u5173\u6ce8\u6df1\u5733\u5de5\u4e1a\u5c55\uff01", wxMessage, wxService);
                }
            }
        }
        return new TextBuilder().build("\u6b22\u8fce\u5173\u6ce8\u6df1\u5733\u5de5\u4e1a\u5c55\uff01", wxMessage, wxService);
    }
}

