/*
 * Decompiled with CFR 0.152.
 */
package com.ites.web.wx.handler;

import com.ites.web.basic.entity.BasicUser;
import com.ites.web.basic.service.BasicUserService;
import com.ites.web.utils.http.HttpUtil;
import com.ites.web.wx.handler.AbstractHandler;
import com.ites.web.wx.properties.WxMpProperties;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubscribeHandler
extends AbstractHandler {
    @Resource
    private WxMpProperties properties;
    @Autowired
    private BasicUserService userService;

    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxService, WxSessionManager sessionManager) throws WxErrorException {
        block8: {
            this.logger.info("\u65b0\u5173\u6ce8\u7528\u6237 OPENID: " + wxMessage.getFromUser());
            try {
                WxMpUser userWxInfo = wxService.getUserService().userInfo(wxMessage.getFromUser());
                this.saveUserInfo(userWxInfo);
                if (userWxInfo == null) {
                    return null;
                }
                Optional<WxMpProperties.MpConfig> optional = this.properties.getConfigs().stream().filter(v -> StringUtils.equals((CharSequence)v.getAppId(), (CharSequence)wxService.getWxMpConfigStorage().getAppId())).findFirst();
                String string = HttpUtil.get((String)(optional.get().getSubscribNotify() + userWxInfo.getUnionId()));
            }
            catch (WxErrorException e) {
                if (e.getError().getErrorCode() != 48001) break block8;
                this.logger.info("\u8be5\u516c\u4f17\u53f7\u6ca1\u6709\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u6743\u9650\uff01");
            }
        }
        WxMpXmlOutMessage responseResult = null;
        try {
            responseResult = this.handleSpecial(wxMessage);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (responseResult != null) {
            return responseResult;
        }
        try {
            return this.buildMessage(wxService, wxMessage, "\u5173\u6ce8\u56de\u590d");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void saveUserInfo(WxMpUser userWxInfo) {
        List list = this.userService.findListByUnionId(userWxInfo.getUnionId());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (BasicUser basicUser : list) {
                basicUser.setSubscribleFlag(Boolean.valueOf(true));
                basicUser.setMpOpenId(userWxInfo.getOpenId());
                basicUser.setUpdateTime(LocalDateTime.now());
                this.userService.updateById((Object)basicUser);
            }
        } else {
            LocalDateTime now = LocalDateTime.now();
            BasicUser newUser = new BasicUser();
            newUser.setMpOpenId(userWxInfo.getOpenId());
            newUser.setUnionid(userWxInfo.getUnionId());
            newUser.setSubscribleFlag(Boolean.valueOf(true));
            newUser.setCreateTime(now);
            newUser.setRemark("\u5173\u6ce8\u516c\u4f17\u53f7\u65b0\u589e");
            this.userService.save((Object)newUser);
        }
    }

    private WxMpXmlOutMessage handleSpecial(WxMpXmlMessage wxMessage) throws Exception {
        return null;
    }
}

