/*
 * Decompiled with CFR 0.152.
 */
package com.joneying.common.job.core.executor.impl;

import com.joneying.common.job.core.executor.XxlJobExecutor;
import com.joneying.common.job.core.glue.GlueFactory;
import com.joneying.common.job.core.handler.IJobHandler;
import com.joneying.common.job.core.handler.annotation.JobHandler;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class XxlJobSpringExecutor
extends XxlJobExecutor
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    @Override
    public void start() throws Exception {
        this.initJobHandlerRepository(applicationContext);
        GlueFactory.refreshInstance(1);
        super.start();
    }

    private void initJobHandlerRepository(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            return;
        }
        Map serviceBeanMap = applicationContext.getBeansWithAnnotation(JobHandler.class);
        if (serviceBeanMap != null && serviceBeanMap.size() > 0) {
            for (Object serviceBean : serviceBeanMap.values()) {
                if (!(serviceBean instanceof IJobHandler)) continue;
                String name = serviceBean.getClass().getAnnotation(JobHandler.class).value();
                IJobHandler handler = (IJobHandler)serviceBean;
                if (XxlJobSpringExecutor.loadJobHandler(name) != null) {
                    throw new RuntimeException("xxl-job jobhandler naming conflicts.");
                }
                XxlJobSpringExecutor.registJobHandler(name, handler);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        XxlJobSpringExecutor.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}

