/*
 * Decompiled with CFR 0.152.
 */
package com.joneying.common.job.core.glue.impl;

import com.joneying.common.job.core.executor.impl.XxlJobSpringExecutor;
import com.joneying.common.job.core.glue.GlueFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.AnnotationUtils;

public class SpringGlueFactory
extends GlueFactory {
    private static Logger logger = LoggerFactory.getLogger(SpringGlueFactory.class);

    @Override
    public void injectService(Object instance) {
        Field[] fields;
        if (instance == null) {
            return;
        }
        if (XxlJobSpringExecutor.getApplicationContext() == null) {
            return;
        }
        for (Field field : fields = instance.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Object fieldBean = null;
            if (AnnotationUtils.getAnnotation((AnnotatedElement)field, Resource.class) != null) {
                try {
                    Resource resource = (Resource)AnnotationUtils.getAnnotation((AnnotatedElement)field, Resource.class);
                    fieldBean = resource.name() != null && resource.name().length() > 0 ? XxlJobSpringExecutor.getApplicationContext().getBean(resource.name()) : XxlJobSpringExecutor.getApplicationContext().getBean(field.getName());
                }
                catch (Exception resource) {
                    // empty catch block
                }
                if (fieldBean == null) {
                    fieldBean = XxlJobSpringExecutor.getApplicationContext().getBean(field.getType());
                }
            } else if (AnnotationUtils.getAnnotation((AnnotatedElement)field, Autowired.class) != null) {
                Qualifier qualifier = (Qualifier)AnnotationUtils.getAnnotation((AnnotatedElement)field, Qualifier.class);
                fieldBean = qualifier != null && qualifier.value() != null && qualifier.value().length() > 0 ? XxlJobSpringExecutor.getApplicationContext().getBean(qualifier.value()) : XxlJobSpringExecutor.getApplicationContext().getBean(field.getType());
            }
            if (fieldBean == null) continue;
            field.setAccessible(true);
            try {
                field.set(instance, fieldBean);
            }
            catch (IllegalArgumentException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

