/*
 * Decompiled with CFR 0.152.
 */
package com.joneying.common.job.core.handler.impl;

import com.joneying.common.job.core.biz.model.ReturnT;
import com.joneying.common.job.core.glue.GlueTypeEnum;
import com.joneying.common.job.core.handler.IJobHandler;
import com.joneying.common.job.core.log.XxlJobFileAppender;
import com.joneying.common.job.core.log.XxlJobLogger;
import com.joneying.common.job.core.util.ScriptUtil;
import com.joneying.common.job.core.util.ShardingUtil;
import java.io.File;

public class ScriptJobHandler
extends IJobHandler {
    private int jobId;
    private long glueUpdatetime;
    private String gluesource;
    private GlueTypeEnum glueType;

    public ScriptJobHandler(int jobId, long glueUpdatetime, String gluesource, GlueTypeEnum glueType) {
        File[] glueSrcFileList;
        this.jobId = jobId;
        this.glueUpdatetime = glueUpdatetime;
        this.gluesource = gluesource;
        this.glueType = glueType;
        File glueSrcPath = new File(XxlJobFileAppender.getGlueSrcPath());
        if (glueSrcPath.exists() && (glueSrcFileList = glueSrcPath.listFiles()) != null && glueSrcFileList.length > 0) {
            for (File glueSrcFileItem : glueSrcFileList) {
                if (!glueSrcFileItem.getName().startsWith(String.valueOf(jobId) + "_")) continue;
                glueSrcFileItem.delete();
            }
        }
    }

    public long getGlueUpdatetime() {
        return this.glueUpdatetime;
    }

    @Override
    public ReturnT<String> execute(String param) throws Exception {
        if (!this.glueType.isScript()) {
            return new ReturnT<String>(IJobHandler.FAIL.getCode(), "glueType[" + (Object)((Object)this.glueType) + "] invalid.");
        }
        String cmd = this.glueType.getCmd();
        String scriptFileName = XxlJobFileAppender.getGlueSrcPath().concat(File.separator).concat(String.valueOf(this.jobId)).concat("_").concat(String.valueOf(this.glueUpdatetime)).concat(this.glueType.getSuffix());
        File scriptFile = new File(scriptFileName);
        if (!scriptFile.exists()) {
            ScriptUtil.markScriptFile(scriptFileName, this.gluesource);
        }
        String logFileName = (String)XxlJobFileAppender.contextHolder.get();
        ShardingUtil.ShardingVO shardingVO = ShardingUtil.getShardingVo();
        String[] scriptParams = new String[]{param, String.valueOf(shardingVO.getIndex()), String.valueOf(shardingVO.getTotal())};
        XxlJobLogger.log("----------- script file:" + scriptFileName + " -----------", new Object[0]);
        int exitValue = ScriptUtil.execToFile(cmd, scriptFileName, logFileName, scriptParams);
        if (exitValue == 0) {
            return IJobHandler.SUCCESS;
        }
        return new ReturnT<String>(IJobHandler.FAIL.getCode(), "script exit value(" + exitValue + ") is failed");
    }
}

