/*
 * Decompiled with CFR 0.152.
 */
package com.joneying.common.job.core.thread;

import com.joneying.common.job.core.biz.AdminBiz;
import com.joneying.common.job.core.biz.model.RegistryParam;
import com.joneying.common.job.core.biz.model.ReturnT;
import com.joneying.common.job.core.enums.RegistryConfig;
import com.joneying.common.job.core.executor.XxlJobExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorRegistryThread
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(ExecutorRegistryThread.class);
    private static ExecutorRegistryThread instance = new ExecutorRegistryThread();
    private Thread registryThread;
    private volatile boolean toStop = false;

    public static ExecutorRegistryThread getInstance() {
        return instance;
    }

    public void start(final String appName, final String address) {
        if (appName == null || appName.trim().length() == 0) {
            logger.warn(">>>>>>>>>>> xxl-job, executor registry config fail, appName is null.");
            return;
        }
        if (XxlJobExecutor.getAdminBizList() == null) {
            logger.warn(">>>>>>>>>>> xxl-job, executor registry config fail, adminAddresses is null.");
            return;
        }
        this.registryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReturnT<String> registryResult;
                RegistryParam registryParam;
                while (!ExecutorRegistryThread.this.toStop) {
                    try {
                        registryParam = new RegistryParam(RegistryConfig.RegistType.EXECUTOR.name(), appName, address);
                        for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
                            try {
                                registryResult = adminBiz.registry(registryParam);
                                if (registryResult != null && 200 == registryResult.getCode()) {
                                    registryResult = ReturnT.SUCCESS;
                                    logger.info(">>>>>>>>>>> xxl-job registry success, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                                    break;
                                }
                                logger.info(">>>>>>>>>>> xxl-job registry fail, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                            }
                            catch (Exception e) {
                                logger.info(">>>>>>>>>>> xxl-job registry error, registryParam:{}", (Object)registryParam, (Object)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    try {
                        TimeUnit.SECONDS.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        logger.warn(">>>>>>>>>>> xxl-job, executor registry thread interrupted, error msg:{}", (Object)e.getMessage());
                    }
                }
                try {
                    registryParam = new RegistryParam(RegistryConfig.RegistType.EXECUTOR.name(), appName, address);
                    for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
                        try {
                            registryResult = adminBiz.registryRemove(registryParam);
                            if (registryResult != null && 200 == registryResult.getCode()) {
                                registryResult = ReturnT.SUCCESS;
                                logger.info(">>>>>>>>>>> xxl-job registry-remove success, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                                break;
                            }
                            logger.info(">>>>>>>>>>> xxl-job registry-remove fail, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                        }
                        catch (Exception e) {
                            logger.info(">>>>>>>>>>> xxl-job registry-remove error, registryParam:{}", (Object)registryParam, (Object)e);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                logger.info(">>>>>>>>>>> xxl-job, executor registry thread destory.");
            }
        });
        this.registryThread.setDaemon(true);
        this.registryThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.registryThread.interrupt();
        try {
            this.registryThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

