/*
 * Decompiled with CFR 0.152.
 */
package com.joneying.common.job.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static boolean deleteRecursively(File root) {
        if (root != null && root.exists()) {
            File[] children;
            if (root.isDirectory() && (children = root.listFiles()) != null) {
                for (File child : children) {
                    FileUtil.deleteRecursively(child);
                }
            }
            return root.delete();
        }
        return false;
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFileLine(String fileName, String content) {
        File file = new File(fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
        }
        if (content == null) {
            content = "";
        }
        content = content + "\r\n";
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, true);
            fos.write(content.getBytes("utf-8"));
            fos.flush();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadFileLines(String fileName) {
        ArrayList<String> result = new ArrayList<String>();
        File file = new File(fileName);
        if (!file.exists()) {
            return result;
        }
        StringBuffer logContentBuffer = new StringBuffer();
        boolean toLineNum = false;
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            String line = null;
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                if (line == null || line.trim().length() <= 0) continue;
                result.add(line);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }
}

