/*
 * Decompiled with CFR 0.152.
 */
package com.joneying.common.redis;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Repository;

@Repository
public class RedisManager {
    @Autowired
    private ValueOperations<String, Object> valueOperations;
    @Autowired
    private HashOperations<String, String, Object> hashOperations;
    @Autowired
    private ListOperations<String, Object> listOperations;

    public void set(String key, Object value) {
        this.valueOperations.set((Object)key, value);
    }

    public Object get(String key) {
        return this.valueOperations.get((Object)key);
    }

    public void set(String key, Object value, long timeout, TimeUnit timeUnit) {
        this.valueOperations.set((Object)key, value, timeout, timeUnit);
    }

    public void set(String key, Object value, long timeout) {
        this.set(key, value, timeout, TimeUnit.SECONDS);
    }

    public void remove(String key) {
        this.valueOperations.getOperations().delete((Object)key);
    }

    public boolean exists(String key) {
        return this.valueOperations.get((Object)key) != null;
    }

    public void hset(String key, String field, Object value) {
        this.hashOperations.put((Object)key, (Object)field, value);
    }

    public Object hget(String key, String field) {
        return this.hashOperations.get((Object)key, (Object)field);
    }

    public boolean hexists(String key, String field) {
        return this.hashOperations.hasKey((Object)key, (Object)field);
    }

    public Map<String, Object> entries(String key) {
        return this.hashOperations.entries((Object)key);
    }

    public void hremove(String key, String ... field) {
        this.hashOperations.delete((Object)key, (Object[])field);
    }

    public void hsetAll(String key, Map<String, Object> m) {
        this.hashOperations.putAll((Object)key, m);
    }
}

