/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary.file;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class ByteFileObject
extends SimpleJavaFileObject {
    private final byte[] bytes;
    private String string;

    ByteFileObject(URI uri, JavaFileObject.Kind kind, byte[] bytes) {
        super(uri, kind);
        this.bytes = bytes;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) {
        return new StringReader(this.toString());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        if (this.string == null) {
            this.string = new String(this.bytes, Charset.defaultCharset());
        }
        return this.string;
    }
}

