/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary.snippet;

import com.karuslabs.utilitary.snippet.Line;
import com.karuslabs.utilitary.snippet.Part;
import com.karuslabs.utilitary.type.TypePrinter;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public class VariableLine
extends Line {
    public final Part<Modifier, Line> modifiers;
    public final Part<AnnotationMirror, Line> annotations;
    public final Line type;
    public final Line name;

    public static VariableLine of(VariableElement variable, int column, int position) {
        return VariableLine.of(variable, true, column, position);
    }

    public static VariableLine of(VariableElement variable, boolean annotated, int column, int position) {
        StringBuilder builder = new StringBuilder();
        Part<Modifier, Line> modifiers = Part.modifiers(variable.getModifiers(), column, position);
        builder.append(modifiers);
        Part<AnnotationMirror, Line> annotations = Part.annotations(annotated ? variable.getAnnotationMirrors() : List.of(), column, position + builder.length());
        builder.append(annotations);
        Line type = new Line(TypePrinter.simple(variable.asType()), column, position + builder.length());
        builder.append(type).append(" ");
        Line name = new Line(variable.getSimpleName().toString(), column, position + builder.length());
        builder.append(name);
        return new VariableLine(modifiers, annotations, type, name, builder.toString(), column, position);
    }

    VariableLine(Part<Modifier, Line> modifiers, Part<AnnotationMirror, Line> annotations, Line type, Line name, String value, int column, int position) {
        super(value, column, position);
        this.modifiers = modifiers;
        this.annotations = annotations;
        this.type = type;
        this.name = name;
    }
}

