/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary.type;

import com.karuslabs.utilitary.Texts;
import com.karuslabs.utilitary.type.TypePrinter;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor9;

public class AnnotationValuePrinter
extends SimpleAnnotationValueVisitor9<Void, StringBuilder> {
    public static final AnnotationValuePrinter PRINTER = new AnnotationValuePrinter();

    public static String annotation(AnnotationMirror annotation) {
        StringBuilder builder = new StringBuilder();
        AnnotationValuePrinter.annotation(annotation, PRINTER, builder);
        return builder.toString();
    }

    static void annotation(AnnotationMirror annotation, AnnotationValuePrinter printer, StringBuilder builder) {
        builder.append('@');
        annotation.getAnnotationType().accept(TypePrinter.simple(), builder);
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        if (values.isEmpty()) {
            return;
        }
        builder.append('(');
        if (values.size() == 1 && ((ExecutableElement[])values.keySet().toArray(ExecutableElement[]::new))[0].getSimpleName().contentEquals("value")) {
            ((AnnotationValue[])values.values().toArray(AnnotationValue[]::new))[0].accept(printer, builder);
        } else {
            Texts.join(builder, values.entrySet(), (mapping, sb) -> {
                sb.append(((ExecutableElement)mapping.getKey()).getSimpleName()).append(" = ");
                ((AnnotationValue)mapping.getValue()).accept(printer, sb);
            }, ", ");
        }
        builder.append(')');
    }

    @Override
    public Void visitAnnotation(AnnotationMirror annotation, StringBuilder builder) {
        AnnotationValuePrinter.annotation(annotation, this, builder);
        return null;
    }

    @Override
    public Void visitArray(List<? extends AnnotationValue> values, StringBuilder builder) {
        if (values.size() == 1) {
            values.get(0).accept(this, builder);
            return null;
        }
        builder.append('{');
        Texts.join(builder, values, (value, sb) -> value.accept(this, sb), ", ");
        builder.append('}');
        return null;
    }

    @Override
    public Void visitEnumConstant(VariableElement value, StringBuilder builder) {
        builder.append(value.getSimpleName());
        return null;
    }

    @Override
    public Void visitString(String value, StringBuilder builder) {
        builder.append("\"").append(value).append("\"");
        return null;
    }

    @Override
    public Void visitType(TypeMirror type, StringBuilder builder) {
        type.accept(TypePrinter.simple(), builder);
        builder.append(".class");
        return null;
    }

    @Override
    protected Void defaultAction(Object object, StringBuilder builder) {
        builder.append(object);
        return null;
    }
}

