package com.simm.erp.dubbo.booth.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author liutao
 * @since 2024/5/8
 */
@Data
public class BoothSaleDTO implements Serializable {

    /**ID*/
    private Integer id;

    /**任务ID*/
    private Integer taskId;

    /**用户ID*/
    private Integer userId;

    /**展商ID*/
    private Integer exhibitorId;

    /**展商名称*/
    private String exhibitorName;

    /**签订合同展商名*/
    private String agreementExhibitName;

    /**展商地址*/
    private String address;

    /**合同类型(cn:中文,en:英文)*/
    private String agreementType;

    /**销售类型(自售,代理)*/
    private Integer saleType;

    /**合同联系人id*/
    private Integer contactId;

    /**代理标识,用于设置是否在合同上显示代理人信息*/
    private Boolean agentFlag;

    /**代理人id*/
    private Integer agentId;

    /**代理企业名称 冗余*/
    private String agentName;

    /**展馆*/
    private String hall;

    /**展位号*/
    private String booth;

    /**展位类型(1:标摊,2:光地)*/
    private Integer boothType;

    /**展位面积(单位:平方米)*/
    private Double boothArea;

    /**赠送面积(单位:平方米)*/
    private Double boothGiveArea;

    /**自定义尺寸标识(0:false,1:true)*/
    private Boolean customFlag;

    /**自定义尺寸说明*/
    private String customSize;

    /**展品描述*/
    private String exhibitionItems;

    /**主办方公司*/
    private String sponsorName;

    /**主办方公司Id*/
    private Integer sponsorId;

    /**原价*/
    private Integer amount;

    /**实际金额*/
    private Integer actualAmount;

    /**折扣*/
    private Integer discount;

    /**付款类型(1:分期付款,2:全款付清)*/
    private Integer paymentType;

    /**预付款金额*/
    private Integer advanceAmount;

    /**余款*/
    private Integer surplusAmount;

    /**预付款截止时间*/
    private String advenceDate;

    /**付余款截止时间*/
    private String surplusDate;

    /**合同备注*/
    private String agreementRemark;

    /**已付金额*/
    private Integer paidAmount;

    /**未付金额*/
    private Integer unpaidAmount;

    /**发票状态(0:未开票,1:已开部分发票,2:已全部开票)*/
    private Integer invoiceStatus;

    /**开通自服务账号状态(0:未开通,1:已开通)*/
    private Integer openAccount;

    /**展商证申领数量*/
    private Integer exhibitCard;

    /**1:价格确认,2:提交报价单审批,3:报价单审批拒绝,4:报价单审批通过,5:已发送报价单,6:提交合同审批 ，7:合同审批拒绝,8:合同审批通过,9:已发送合同,10:待付款, 11:已付部分款,12:交易完成)*/
    private Integer serviceStates;

    /**状态(1:有效,-1:作废)*/
    private Integer status;

    /**高*/
    private Double high;

    /**宽*/
    private Double wide;

    /**是否特批*/
    private Boolean specciallyApplyFlag;

    /**特批原因*/
    private String speaciallyApplyReason;

    /**参展确认函*/
    private String exhibitionLetterUrl;


    /**补充协议状态 1-已生成 2-已回传*/
    private Integer supplyAgreementStatus;

    /**补充协议地址*/
    private String supplyAgreementUrl;

    /**回传补充协议地址*/
    private String backSupplyAgreementUrl;

    /**说明函*/
    private String explanatoryNoteUrl;

    /**1-审批中 2-审批通过 3-审批拒绝*/
    private Integer agentBookAuditStatus;

    private String createBy;

    private String lastUpdateBy;

    private String remark;

    private Integer createById;

    private String contactEmail;

    private String contactPhone;

    private String contactName;

    /**展会名称*/
    private String exhibitionName;

    /**订单id*/
    private Integer orderId;

    /**订单号*/
    private String orderNo;

    /**届数*/
    private Integer number;

    /**年份*/
    private Integer year;

    /**合同金额*/
    private Integer agreementAmount;

    /**产品名称*/
    private String productName;

    /**代理联系人id*/
    private Integer agentContactId;

    /**订单类型*/
    private Integer orderType;

    /**是否锁定*/
    private Boolean isLock;

    private Long regionId;

    /**订单状态*/
    private Integer orderStatus;

    /**布撤展文件*/
    private String moveInAndOutUrl;

    /**布撤展发送状态 0 未发送 1 已发送*/
    private Integer moveInAndOutStatus;

    /**主题名称*/
    private String themeName;
}
