package com.simm.erp.dubbo.booth.service;

import com.simm.erp.dubbo.booth.dto.BoothSaleDTO;
import com.simm.erp.dubbo.booth.dto.BoothSaleFileUrl;

import java.util.List;

/**
 * @author liutao
 * @since 2024/5/8
 */
public interface BoothSaleDubboService {

    /**
     * 根据展位号查询展位销售信息
     * @param boothNo 展位号
     * @return {@link BoothSaleDTO}
     */
    BoothSaleDTO findByBoothNo(String boothNo);

    /**
     * 根据展商id查询文件
     * @param exhibitorId 展商id
     * @return {@link BoothSaleFileUrl}
     */
    List<BoothSaleFileUrl> getFileByExhibitorId(Integer exhibitorId);
}
