package com.simm.exhibitor.bean.basic;

import com.simm.common.bean.BaseBean;
import com.simm.exhibitor.bean.exhibitors.SmebExhibitorInfoExhibit;
import com.simm.exhibitor.bean.exhibitors.SmebSiteActivity;
import com.simm.exhibitor.bean.exhibitors.SmebSiteActivityDTO;
import com.simm.exhibitor.bean.pojo.UserSession;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.util.Date;
import java.util.List;

/**
* Created by Mybatis Generator on 2021/05/24 10:25
*/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
@ToString
public class SmebExhibitorInfo extends BaseBean {

    @ApiModelProperty("")
    private Integer id;

    @ApiModelProperty("父id")
    private Integer pid;

    @ApiModelProperty("展商id（smdm_exhibitor_baseinfo.id）")
    private Integer exhibitorBaseinfoId;

    @ApiModelProperty("微信openid（允许多个，逗号分隔）")
    private String openId;

    @ApiModelProperty("用户名")
    private String username;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("")
    private String uniqueId;

    @ApiModelProperty("公司名")
    private String businessName;

    @ApiModelProperty("公司名简称")
    private String businessNameShort;

    @ApiModelProperty("公司英文名称")
    private String businessNameEn;

    @ApiModelProperty("公司称号")
    private String businessTitle;

    @ApiModelProperty("股票代码")
    private String stockCode;

    @ApiModelProperty("上市状态")
    private Integer listedStatus;

    @ApiModelProperty("logo地址")
    private String logoUrl;

    @ApiModelProperty("联系人")
    private String contactName;

    @ApiModelProperty("联系人手机")
    private String contactMobile;

    @ApiModelProperty("联系人邮箱")
    private String contactEmail;

    @ApiModelProperty("第二联系人")
    private String secondContactName;

    @ApiModelProperty("第二联系人手机号码")
    private String secondContactMobile;

    @ApiModelProperty("第二联系人邮箱")
    private String secondContactEmail;

    @ApiModelProperty("会刊公司名")
    private String comBusinessName;

    @ApiModelProperty("会刊公司名")
    private String comBusinessNameEn;

    @ApiModelProperty("会刊公司座机")
    private String comBusinessTelphone;

    @ApiModelProperty("会刊公司地址")
    private String comBusinessAddress;

    @ApiModelProperty("会刊公司英文地址")
    private String comBusinessAddressEn;

    @ApiModelProperty("会刊公司网址")
    private String comBusinessWebsite;

    @ApiModelProperty("会刊公司传真")
    private String comBusinessFax;

    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("品牌名称-英文")
    private String brandNameEn;

    @ApiModelProperty("展品类别")
    private String exhibitsCategory;

    @ApiModelProperty("知名品牌（0：否，1：是）")
    private Integer isBrands;

    @ApiModelProperty("人气企业")
    private Integer isPopularBusiness;

    @ApiModelProperty("公司简介")
    private String introduce;

    @ApiModelProperty("公司简介（英文）")
    private String introduceEn;

    @ApiModelProperty("优势")
    private String advantage;

    @ApiModelProperty("应用行业")
    private String applicationIndustry;

    @ApiModelProperty("应用行业（英文）")
    private String applicationIndustryEn;

    @ApiModelProperty("展区分类")
    private String exhibitionAreaClassify;

    @ApiModelProperty("主营产品")
    private String mainProduct;

    @ApiModelProperty("主营产品（英文）")
    private String mainProductEn;

    @ApiModelProperty("届数")
    private Integer number;

    @ApiModelProperty("年份")
    private Integer year;

    @ApiModelProperty("展会名（合同需要）")
    private String exhibitTitle;

    @ApiModelProperty("展会名称")
    private String exhibitName;

    @ApiModelProperty("展会时间")
    private String exhibitTime;

    @ApiModelProperty("展会地点")
    private String exhibitAddress;

    @ApiModelProperty("主办方公司网址")
    private String sponsorWebsite;

    @ApiModelProperty("")
    private Integer countryId;

    @ApiModelProperty("")
    private String countryName;

    @ApiModelProperty("")
    private Integer provinceId;

    @ApiModelProperty("")
    private String provinceName;

    @ApiModelProperty("")
    private Integer cityId;

    @ApiModelProperty("")
    private String cityName;

    @ApiModelProperty("")
    private Integer areaId;

    @ApiModelProperty("")
    private String areaName;

    @ApiModelProperty("校验方式（1：手机，2：邮箱）")
    private Integer checkWay;

    @ApiModelProperty("广告商")
    private Boolean advertFlag;

    @ApiModelProperty("视频链接")
    private String videoUrl;

    @ApiModelProperty("视频图片地址")
    private String videoCoverUrl;

    @ApiModelProperty("展馆")
    private String boothId;

    @ApiModelProperty("'展位号")
    private String boothNo;

    @ApiModelProperty("展位面积(单位:平方米)")
    private Double boothArea;

    @ApiModelProperty("展位类型(1:标摊,2:光地)")
    private Integer boothType;

    @ApiModelProperty("主办方公司id")
    private Integer sponsorId;

    @ApiModelProperty("主办方公司名称")
    private String sponsorName;

    @ApiModelProperty("收款账户")
    private String receiptBankAccount;

    @ApiModelProperty("收款账户 英文")
    private String receiptBankAccountEn;

    @ApiModelProperty("开户行")
    private String bank;

    @ApiModelProperty("开户行 英文")
    private String bankEn;

    @ApiModelProperty("帐号")
    private String accounts;

    @ApiModelProperty("帐号 英文")
    private String accountsEn;

    @ApiModelProperty("是否开通")
    private Integer enable;

    @ApiModelProperty("审批状态 -1-未审批 0-初始化状态 1-审批通过 2-审批拒绝 3-中文审批通过，英文未通过")
    private Integer approveStatus;

    @ApiModelProperty("审批备注")
    private String approveRemark;

    @ApiModelProperty("")
    private Integer createById;

    @ApiModelProperty("")
    private String createBy;

    @ApiModelProperty("")
    private Date createTime;

    @ApiModelProperty("")
    private String lastUpdateBy;

    @ApiModelProperty("")
    private Date lastUpdateTime;

    @ApiModelProperty("状态（1：正常，-1：异常，2：作废）")
    private Integer status;

    @ApiModelProperty("最后登录时间")
    private Date lastLoginTime;

    @ApiModelProperty("小程序码图片地址")
    private String mpcodeUrl;

    @ApiModelProperty("路线图片地址")
    private String routeImgUrl;

    @ApiModelProperty("图标")
    private Integer icon;

    @ApiModelProperty("无销售信息")
    private Boolean noSaleFlag;

    @ApiModelProperty("待领款金额")
    private Integer waitConfirmMoney;

    @ApiModelProperty("待领款总金额")
    private Integer waitConfirmTotalMoney;


    //冗余
    private List<Integer> roleIds;

    @ApiModelProperty("展商ids")
    private List<Integer> exhibitorBaseinfoIds;

    private List<SmebExhibitorInfoRole> exhibitorInfoRoleList;

    @ApiModelProperty("展品类别")
    private List<List<String>> exhibitsCategorys;

    @ApiModelProperty("展品")
    private List<SmebExhibitorInfoExhibit> exhibits;

    @ApiModelProperty("应用行业")
    private List<String> applicationIndustrys;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("水电订单欠款")
    private int unPaidAmountSmeb;

    private Boolean hasShipmentOrder;

    //展商维度，结果集
    public boolean passTicketflag;
    public boolean exhibitorInfoflag;
    public boolean buildflag;
    public boolean yellowcarflag;
    public boolean expresseflag;
    public boolean bluecarInfoflag;
    public boolean exhibitRecordflag;
    public boolean Forkliftflag;
    public boolean paymentVoucherflag;
    public boolean serviceOrderflag;
    public boolean electricboxImgflag;
    public boolean invitationflag;

    // 是否上传防疫承诺书
    public boolean uploadEpidemicPreventionFlag;

    //查询条件
    @ApiModelProperty("展会名称")
    private List<String> exhibitNames;

    @ApiModelProperty("主键ids")
    private List<Integer> ids;

    @ApiModelProperty("唯一id")
    private List<String> uniqueIds;

    @ApiModelProperty("手机验证码")
    private String smsCode;

    @ApiModelProperty("邮箱验证码")
    private String emailCode;

    @ApiModelProperty("代理商id")
    private Integer agentId;

    @ApiModelProperty("公司名或者展位号")
    private String businessNameOrBoothNo;

    @ApiModelProperty("展品冗余字段")
    private List<SmebExhibitorInfoExhibit> exhibitList;

    @ApiModelProperty("appid")
    private String appid;

    @ApiModelProperty("是否提交承运承建信息")
    private Boolean shipment;

    @ApiModelProperty("是否填写公司英文简介")
    private Boolean hasIntroduceEn;

    @ApiModelProperty("承运信息id")
    private Boolean shipmentBaseId;

    @ApiModelProperty("承运实收金额(单位：分)")
    private Integer shipmentActualAmount;

    @ApiModelProperty("已确认金额")
    private Integer confirmMoney;

    @ApiModelProperty("申报状态（1：未申报,2：一申报，3：已回传申报单）")
    private Integer declarationStatus;

    @ApiModelProperty("待领款金额状态（1：未预付款,2:已预付款）")
    private Integer waitConfirmMoneyStatus;

    @ApiModelProperty("已确认金额状态(1：已结清,2：需补缴，3：需退回)")
    private Integer confirmMoneyStatus;

    @ApiModelProperty("现场活动集合")
    private List<SmebSiteActivity> siteActivityList;

    @ApiModelProperty("现场活动集合")
    private List<SmebSiteActivityDTO> siteActivityDTOList;

    @ApiModelProperty("承运订单页面查询条件-作业时间")
    private Date workDate;

    @ApiModelProperty("承运订单页面查询条件-订单状态，1：未付款，2：已付款，3：已付部分款")
    private Integer orderStatus;

    private Boolean external;

    private String draft;

    @ApiModelProperty("审批状态")
    private List<Integer> approveStatusList;

    public UserSession conversion() {
        UserSession session = new UserSession();
        session.setPid(this.getPid());
        session.setUserId(this.getId());
        session.setUsername(this.getUsername());
        session.setUniqueId(this.getUniqueId());
        session.setBusinessName(this.getBusinessName());
        session.setContactMobile(this.contactMobile);
        session.setContactName(this.contactName);
        session.setContactEmail(this.contactEmail);
        session.setExhibitorBaseinfoId(this.getExhibitorBaseinfoId());
        session.setBoothNo(this.getBoothNo());
        session.setBoothArea(this.getBoothArea());
        session.setBoothId(this.getBoothId());
        session.setBoothType(this.boothType);
        session.setRemark(this.getRemark());
        return session;
    }
}